/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.basis.EndTerrainBlock;
import org.betterx.betterend.registry.EndBlocks;

public class PallidiumBlock
extends EndTerrainBlock {
    private final Block nextLevel;

    public PallidiumBlock(String thickness, Block nextLevel) {
        super(MapColor.COLOR_LIGHT_GRAY);
        this.nextLevel = nextLevel;
    }

    @Override
    public boolean canBePotted() {
        return this == EndBlocks.PALLIDIUM_FULL;
    }

    public Block getBaseBlock() {
        return EndBlocks.UMBRALITH.stone;
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.nextLevel == null) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (itemStack.is(Items.BONE_MEAL)) {
            BlocksHelper.setWithUpdate((LevelAccessor)level, (BlockPos)pos, (Block)this.nextLevel);
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }
}

