/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BaseAttachedBlock;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.betterend.interfaces.survives.SurvivesOnBrimstone;
import org.betterx.betterend.registry.EndItems;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SulphurCrystalBlock
extends BaseAttachedBlock.Glass
implements RenderLayerProvider,
SimpleWaterloggedBlock,
LiquidBlockContainer,
SurvivesOnBrimstone,
BlockLootProvider {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap(Direction.class);
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)2);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public SulphurCrystalBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).sound(SoundType.GLASS).requiresCorrectToolForDrops().noCollission());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.createBlockStateDefinition(stateManager);
        stateManager.add(new Property[]{AGE, WATERLOGGED});
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootItemConditionalFunction.Builder<?> applyAgeBonus(@NotNull LootLookupProvider provider, int i) {
        return ApplyBonusCount.addUniformBonusCount((Holder)provider.fortune(), (int)i).when((LootItemCondition.Builder)this.ageCondition(i));
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull LootItemBlockStatePropertyCondition.Builder ageCondition(int i) {
        return LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)this).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)AGE, i));
    }

    public LootTable.Builder registerBlockLoot(@NotNull ResourceLocation location, @NotNull LootLookupProvider provider, @NotNull ResourceKey<LootTable> tableKey) {
        return LootTable.lootTable().withPool(LootPool.lootPool().when(provider.hasSilkTouch()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)this).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).when((LootItemCondition.Builder)this.ageCondition(3))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)this.ageCondition(3)))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)provider.fortune()).when((LootItemCondition.Builder)this.ageCondition(3))).apply(this.applyAgeBonus(provider, 2)).apply(this.applyAgeBonus(provider, 1)).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)AllOfCondition.allOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{InvertedLootItemCondition.invert((LootItemCondition.Builder)provider.hasSilkTouch()), this.ageCondition(3)})).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EndItems.CRYSTALLINE_SULPHUR).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay())));
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) == false;
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        if (state != null) {
            BlockPos blockPos;
            Level worldView = ctx.getLevel();
            boolean water = worldView.getFluidState(blockPos = ctx.getClickedPos()).getType() == Fluids.WATER;
            return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
        }
        return null;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return BOUNDING_SHAPES.get(state.getValue((Property)FACING));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockPos = pos.relative(direction.getOpposite());
        return this.isTerrain(world.getBlockState(blockPos));
    }

    static {
        BOUNDING_SHAPES.put(Direction.UP, Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.5, (double)0.875));
        BOUNDING_SHAPES.put(Direction.DOWN, Shapes.box((double)0.125, (double)0.5, (double)0.125, (double)0.875, (double)1.0, (double)0.875));
        BOUNDING_SHAPES.put(Direction.NORTH, Shapes.box((double)0.125, (double)0.125, (double)0.5, (double)0.875, (double)0.875, (double)1.0));
        BOUNDING_SHAPES.put(Direction.SOUTH, Shapes.box((double)0.125, (double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)0.5));
        BOUNDING_SHAPES.put(Direction.WEST, Shapes.box((double)0.5, (double)0.125, (double)0.125, (double)1.0, (double)0.875, (double)0.875));
        BOUNDING_SHAPES.put(Direction.EAST, Shapes.box((double)0.0, (double)0.125, (double)0.125, (double)0.5, (double)0.875, (double)0.875));
    }
}

