/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.betterend.blocks.basis.PedestalBlock;
import org.betterx.betterend.registry.EndBlockEntities;
import org.betterx.betterend.registry.EndItems;
import org.jetbrains.annotations.NotNull;

public class PedestalBlockEntity
extends BlockEntity
implements Container {
    private ItemStack activeItem = ItemStack.EMPTY;

    public PedestalBlockEntity(BlockPos blockPos, BlockState blockState) {
        this(EndBlockEntities.PEDESTAL, blockPos, blockState);
    }

    public PedestalBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.activeItem.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return this.activeItem;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        return this.removeItemNoUpdate(slot);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.isEmpty();
    }

    public void clearContent() {
        this.activeItem = ItemStack.EMPTY;
        this.setChanged();
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stored = this.activeItem;
        this.clearContent();
        return stored;
    }

    public void setItem(int slot, ItemStack stack) {
        this.activeItem = stack.split(1);
        this.setChanged();
    }

    public void setChanged() {
        if (this.level != null && !this.level.isClientSide()) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            if (state.getBlock() instanceof PedestalBlock) {
                state = (BlockState)state.setValue((Property)PedestalBlock.HAS_ITEM, (Comparable)Boolean.valueOf(!this.isEmpty()));
                state = (BlockState)state.setValue((Property)PedestalBlock.HAS_LIGHT, (Comparable)Boolean.valueOf(this.activeItem.getItem() == EndItems.ETERNAL_CRYSTAL));
            }
            this.level.setBlockAndUpdate(this.worldPosition, state);
            this.level.blockEntityChanged(this.worldPosition);
        }
        super.setChanged();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("active_item")) {
            CompoundTag itemTag = tag.getCompound("active_item");
            this.activeItem = ItemStack.parse((HolderLookup.Provider)provider, (Tag)itemTag).orElse(ItemStack.EMPTY);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (this.activeItem != ItemStack.EMPTY) {
            tag.put("active_item", this.activeItem.save(provider, (Tag)new CompoundTag()));
        }
        super.saveAdditional(tag, provider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }
}

