/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client;

import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.client.render.BetterEndSkyEffect;
import org.betterx.betterend.config.Configs;
import org.betterx.betterend.config.screen.ConfigScreen;
import org.betterx.betterend.events.ItemTooltipCallback;
import org.betterx.betterend.interfaces.MultiModelItem;
import org.betterx.betterend.item.CrystaliteArmor;
import org.betterx.betterend.registry.EndBlockEntityRenders;
import org.betterx.betterend.registry.EndEntitiesRenders;
import org.betterx.betterend.registry.EndModelProviders;
import org.betterx.betterend.registry.EndParticles;
import org.betterx.betterend.registry.EndScreens;
import org.betterx.betterend.world.generator.GeneratorOptions;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="betterend", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BetterEndClient {
    private static final ModelResourceLocation CHECK_FLOWER_ID = ModelResourceLocation.inventory((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"chorus_flower"));
    private static final ModelResourceLocation CHECK_PLANT_ID = ModelResourceLocation.inventory((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"chorus_plant"));
    private static final ModelResourceLocation TO_LOAD_FLOWER_ID = ModelResourceLocation.standalone((ResourceLocation)BetterEnd.C.mk("item/custom_chorus_flower"));
    private static final ModelResourceLocation TO_LOAD_PLANT_ID = ModelResourceLocation.standalone((ResourceLocation)BetterEnd.C.mk("item/custom_chorus_plant"));

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            EndModelProviders.register();
            MultiModelItem.register();
            BetterEndClient.registerTooltips();
            IConfigScreenFactory factory = (modContainer, parent) -> new ConfigScreen(parent);
            ModList.get().getModContainerById("betterend").ifPresent(container -> container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)factory));
            NeoForge.EVENT_BUS.addListener(BetterEndClient::onItemTooltip);
        });
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        EndScreens.register(event);
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        EndParticles.registerProviders(event);
    }

    @SubscribeEvent
    public static void registerDimensionEffects(RegisterDimensionSpecialEffectsEvent event) {
        if (!((Boolean)Configs.CLIENT_CONFIG.customSky.get()).booleanValue()) {
            return;
        }
        event.register(ResourceLocation.withDefaultNamespace((String)"the_end"), (DimensionSpecialEffects)new BetterEndSkyEffect());
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        EndEntitiesRenders.registerRenderers(event);
        EndBlockEntityRenders.registerRenderers(event);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        EndEntitiesRenders.registerLayerDefinitions(event);
    }

    @SubscribeEvent
    public static void onRegisterAdditionalModels(ModelEvent.RegisterAdditional event) {
        if (!GeneratorOptions.changeChorusPlant()) {
            return;
        }
        event.register(TO_LOAD_FLOWER_ID);
        event.register(TO_LOAD_PLANT_ID);
    }

    @SubscribeEvent
    public static void onModifyBakedModels(ModelEvent.ModifyBakingResult event) {
        Map models = event.getModels();
        if (GeneratorOptions.changeChorusPlant()) {
            BakedModel flowerModel = (BakedModel)models.get(TO_LOAD_FLOWER_ID);
            BakedModel plantModel = (BakedModel)models.get(TO_LOAD_PLANT_ID);
            if (flowerModel != null) {
                models.put(CHECK_FLOWER_ID, flowerModel);
            }
            if (plantModel != null) {
                models.put(CHECK_PLANT_ID, plantModel);
            }
        }
    }

    private static void onItemTooltip(ItemTooltipEvent event) {
        ItemTooltipCallback.fire(event.getEntity(), event.getItemStack(), event.getFlags(), event.getToolTip());
    }

    public static void registerTooltips() {
        ItemTooltipCallback.register((player, stack, context, lines) -> {
            if (stack.getItem() instanceof CrystaliteArmor) {
                boolean hasSet = false;
                if (player != null) {
                    hasSet = CrystaliteArmor.hasFullSet((LivingEntity)player);
                }
                MutableComponent setDesc = Component.translatable((String)"tooltip.armor.crystalite_set");
                setDesc.setStyle(Style.EMPTY.applyFormats(new ChatFormatting[]{hasSet ? ChatFormatting.BLUE : ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                lines.add(Component.empty());
                lines.add(setDesc);
            }
        });
    }
}

