/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.items.elytra.BCLElytraItem;
import org.betterx.bclib.items.elytra.BCLElytraUtils;
import org.betterx.betterend.item.model.ArmoredElytraModel;
import org.betterx.betterend.registry.EndEntitiesRenders;

@OnlyIn(value=Dist.CLIENT)
public class ArmoredElytraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends ElytraLayer<T, M> {
    private static final ResourceLocation VANILLA_WINGS = ResourceLocation.withDefaultNamespace((String)"textures/entity/elytra.png");
    private final ArmoredElytraModel<T> elytraModel;

    public ArmoredElytraLayer(RenderLayerParent<T, M> renderLayerParent, EntityModelSet entityModelSet) {
        super(renderLayerParent, entityModelSet);
        ArmoredElytraModel model;
        try {
            model = new ArmoredElytraModel(entityModelSet.bakeLayer(EndEntitiesRenders.ARMORED_ELYTRA));
        }
        catch (IllegalArgumentException ex) {
            model = null;
        }
        this.elytraModel = model;
    }

    public ResourceLocation wingTextureOverride(T livingEntity) {
        ItemStack itemStack;
        ItemStack itemStack2 = itemStack = BCLElytraUtils.slotProvider == null ? livingEntity.getItemBySlot(EquipmentSlot.CHEST) : BCLElytraUtils.slotProvider.getElytra(livingEntity, arg_0 -> livingEntity.getItemBySlot(arg_0));
        if (itemStack != null && itemStack.getItem() instanceof BCLElytraItem) {
            return ((BCLElytraItem)itemStack.getItem()).getModelTexture();
        }
        return VANILLA_WINGS;
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T livingEntity, float f, float g, float h, float j, float k, float l) {
        if (this.elytraModel == null) {
            return;
        }
        ItemStack itemStack = livingEntity.getItemBySlot(EquipmentSlot.CHEST);
        if (itemStack.is(Items.ELYTRA)) {
            AbstractClientPlayer abstractClientPlayer;
            PlayerSkin playerSkin;
            ResourceLocation resourceLocation = livingEntity instanceof AbstractClientPlayer ? ((playerSkin = (abstractClientPlayer = (AbstractClientPlayer)livingEntity).getSkin()).elytraTexture() != null ? playerSkin.elytraTexture() : (playerSkin.capeTexture() != null && abstractClientPlayer.isModelPartShown(PlayerModelPart.CAPE) ? playerSkin.capeTexture() : this.wingTextureOverride(livingEntity))) : this.wingTextureOverride(livingEntity);
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 0.125f);
            this.getParentModel().copyPropertiesTo(this.elytraModel);
            this.elytraModel.setupAnim(livingEntity, f, g, j, k, l);
            VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)multiBufferSource, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)resourceLocation), (boolean)itemStack.hasFoil());
            this.elytraModel.renderToBuffer(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

