/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.effects;

import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.effects.EndStatusEffects;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.wover.events.api.Subscriber;
import org.betterx.wover.potions.api.OnBootstrapPotions;
import org.betterx.wover.potions.api.PotionManager;
import org.jetbrains.annotations.ApiStatus;

public class EndPotions {
    private static final ResourceKey<Potion> END_VEIL_KEY = ResourceKey.create((ResourceKey)Registries.POTION, (ResourceLocation)BetterEnd.C.mk("end_veil"));
    private static final ResourceKey<Potion> LONG_END_VEIL_KEY = ResourceKey.create((ResourceKey)Registries.POTION, (ResourceLocation)BetterEnd.C.mk("long_end_veil"));
    public static Holder<Potion> END_VEIL;
    public static Holder<Potion> LONG_END_VEIL;

    @ApiStatus.Internal
    public static void register() {
        PotionManager.BOOTSTRAP_POTIONS.subscribe((Subscriber)((OnBootstrapPotions)EndPotions::bootstrap));
    }

    public static void onRegister(RegisterEvent event) {
        if (!event.getRegistryKey().equals(Registries.POTION)) {
            return;
        }
        event.register(Registries.POTION, helper -> {
            helper.register(END_VEIL_KEY.location(), (Object)new Potion("betterend_end_veil", new MobEffectInstance[]{new MobEffectInstance(EndStatusEffects.END_VEIL, 3600)}));
            helper.register(LONG_END_VEIL_KEY.location(), (Object)new Potion("betterend_long_end_veil", new MobEffectInstance[]{new MobEffectInstance(EndStatusEffects.END_VEIL, 9600)}));
            END_VEIL = (Holder)BuiltInRegistries.POTION.getHolder(END_VEIL_KEY).orElseThrow();
            LONG_END_VEIL = (Holder)BuiltInRegistries.POTION.getHolder(LONG_END_VEIL_KEY).orElseThrow();
        });
    }

    private static void bootstrap(PotionBrewing.Builder builder) {
        builder.addMix(Potions.AWKWARD, EndItems.ENDER_DUST, Objects.requireNonNull(END_VEIL));
        builder.addMix(END_VEIL, Items.REDSTONE, Objects.requireNonNull(LONG_END_VEIL));
        builder.addMix(Potions.AWKWARD, EndBlocks.MURKWEED.asItem(), Potions.NIGHT_VISION);
    }
}

