/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.EndItems;
import org.betterx.wover.enchantment.api.EnchantmentUtils;
import org.jetbrains.annotations.NotNull;

public class EndFishEntity
extends AbstractSchoolingFish {
    public static final int VARIANTS_NORMAL = 5;
    public static final int VARIANTS_SULPHUR = 3;
    public static final int VARIANTS = 8;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(EndFishEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SCALE = SynchedEntityData.defineId(EndFishEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public EndFishEntity(EntityType<EndFishEntity> entityType, Level world) {
        super(entityType, world);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, SpawnGroupData entityData) {
        SpawnGroupData data = super.finalizeSpawn(world, difficulty, spawnReason, entityData);
        Holder biome = world.getBiome(this.blockPosition());
        if (biome.is(EndBiomes.SULPHUR_SPRINGS.key)) {
            this.entityData.set(VARIANT, (Object)(this.random.nextInt(3) + 5));
        }
        this.refreshDimensions();
        return data;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)this.getRandom().nextInt(5));
        builder.define(SCALE, (Object)this.getRandom().nextInt(16));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getVariant());
        tag.putInt("Scale", ((Integer)this.entityData.get(SCALE)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Variant")) {
            this.entityData.set(VARIANT, (Object)tag.getInt("Variant"));
        }
        if (tag.contains("Scale")) {
            this.entityData.set(SCALE, (Object)tag.getInt("Scale"));
        }
    }

    public void saveToBucketTag(ItemStack itemStack) {
        super.saveToBucketTag(itemStack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)itemStack, tag -> {
            tag.putInt("variant", ((Integer)this.entityData.get(VARIANT)).intValue());
            tag.putInt("scale", ((Integer)this.entityData.get(SCALE)).intValue());
        });
    }

    @NotNull
    public ItemStack getBucketItemStack() {
        ItemStack bucket = EndItems.BUCKET_END_FISH.getDefaultInstance();
        return bucket;
    }

    @NotNull
    protected SoundEvent getFlopSound() {
        return SoundEvents.TROPICAL_FISH_FLOP;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SALMON_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SALMON_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.SALMON_HURT;
    }

    public void tick() {
        super.tick();
        if (this.random.nextInt(8) == 0 && this.getInBlockState().is(Blocks.WATER)) {
            double x = this.getX() + this.random.nextGaussian() * 0.2;
            double y = this.getY() + this.random.nextGaussian() * 0.2;
            double z = this.getZ() + this.random.nextGaussian() * 0.2;
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 2.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MOVEMENT_SPEED, 0.75);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public float getScale() {
        return (float)((Integer)this.entityData.get(SCALE)).intValue() / 32.0f + 0.75f;
    }

    protected void dropFromLootTable(DamageSource source, boolean causedByPlayer) {
        Item item;
        Item item2 = item = source.is(DamageTypeTags.IS_FIRE) ? EndItems.END_FISH_COOKED : EndItems.END_FISH_RAW;
        if (causedByPlayer) {
            ItemStack handItem = ((Player)source.getEntity()).getItemInHand(InteractionHand.MAIN_HAND);
            if (EnchantmentUtils.getItemEnchantmentLevel((Level)source.getEntity().level(), (ResourceKey)Enchantments.FIRE_ASPECT, (ItemStack)handItem) > 0) {
                item = EndItems.END_FISH_COOKED;
            }
        }
        ItemEntity drop = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)item));
        this.level().addFreshEntity((Entity)drop);
    }
}

