/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import org.betterx.betterend.entity.DragonflyEntity;

public class DragonflyEntityModel
extends EntityModel<DragonflyEntity> {
    private final ModelPart model;
    private final ModelPart head;
    private final ModelPart tail;
    private final ModelPart tail_2;
    private final ModelPart wing_1;
    private final ModelPart wing_2;
    private final ModelPart wing_3;
    private final ModelPart wing_4;
    private final ModelPart legs_1;
    private final ModelPart legs_2;

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition bodyPart = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, 0.0f, 4.0f, 4.0f, 9.0f), PartPose.offset((float)2.0f, (float)21.5f, (float)-4.0f));
        bodyPart.addOrReplaceChild("head", CubeListBuilder.create().texOffs(17, 0).addBox(-1.5f, -1.5f, -2.5f, 3.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-2.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition tailPart = bodyPart.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(26, 0).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 7.0f), PartPose.offset((float)-2.0f, (float)-2.0f, (float)9.0f));
        tailPart.addOrReplaceChild("tail_fin", CubeListBuilder.create().texOffs(36, 0).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 10.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)7.0f));
        bodyPart.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 13).addBox(-15.0f, 0.0f, -3.0f, 15.0f, 0.0f, 4.0f), PartPose.offset((float)-2.0f, (float)-4.0f, (float)4.0f));
        bodyPart.addOrReplaceChild("right_wing", CubeListBuilder.create().mirror().texOffs(0, 13).addBox(0.0f, 0.0f, -3.0f, 15.0f, 0.0f, 4.0f), PartPose.offset((float)-2.0f, (float)-4.0f, (float)4.0f));
        bodyPart.addOrReplaceChild("left_wing_base", CubeListBuilder.create().texOffs(4, 17).addBox(-12.0f, 0.0f, -2.5f, 12.0f, 0.0f, 3.0f), PartPose.offset((float)-2.0f, (float)-4.0f, (float)8.0f));
        bodyPart.addOrReplaceChild("right_wing_base", CubeListBuilder.create().mirror().texOffs(4, 17).addBox(0.0f, 0.0f, -2.5f, 12.0f, 0.0f, 3.0f), PartPose.offset((float)-2.0f, (float)-4.0f, (float)8.0f));
        bodyPart.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(50, 1).addBox(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 6.0f), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        bodyPart.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(50, 1).addBox(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 6.0f), PartPose.offsetAndRotation((float)-3.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public DragonflyEntityModel(ModelPart modelPart) {
        super(RenderType::entityCutout);
        this.model = modelPart.getChild("body");
        this.head = this.model.getChild("head");
        this.tail = this.model.getChild("tail");
        this.tail_2 = this.tail.getChild("tail_fin");
        this.wing_1 = this.model.getChild("left_wing");
        this.wing_2 = this.model.getChild("right_wing");
        this.wing_3 = this.model.getChild("left_wing_base");
        this.wing_4 = this.model.getChild("right_wing_base");
        this.legs_1 = this.model.getChild("left_leg");
        this.legs_2 = this.model.getChild("right_leg");
    }

    public void setupAnim(DragonflyEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float progress = animationProgress * 2.0f;
        this.wing_1.zRot = 0.3491f + (float)Math.sin(progress) * 0.3491f;
        this.wing_2.zRot = -this.wing_1.zRot;
        this.wing_3.zRot = 0.3491f + (float)Math.cos(progress) * 0.3491f;
        this.wing_4.zRot = -this.wing_3.zRot;
        progress = animationProgress * 0.05f;
        this.head.xRot = 0.3491f + (float)Math.sin(progress * 0.7f) * 0.1f;
        this.tail.xRot = (float)Math.cos(progress) * 0.05f - 0.05f;
        this.tail_2.xRot = -this.tail.xRot * 1.5f;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.model.render(matrices, vertices, light, overlay);
    }
}

