/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import org.betterx.betterend.entity.EndFishEntity;

public class EndFishEntityModel
extends EntityModel<EndFishEntity> {
    private final ModelPart model;
    private final ModelPart fin_top;
    private final ModelPart fin_bottom;
    private final ModelPart flipper;
    private final ModelPart fin_right;
    private final ModelPart fin_left;

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition bodyPart = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, -4.0f, 2.0f, 4.0f, 8.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        bodyPart.addOrReplaceChild("top_fin", CubeListBuilder.create().texOffs(0, 6).addBox(0.0f, -8.0f, 0.0f, 0.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-4.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        bodyPart.addOrReplaceChild("bottom_fin", CubeListBuilder.create().texOffs(0, 6).addBox(0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-4.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        bodyPart.addOrReplaceChild("tail_fin", CubeListBuilder.create().texOffs(0, 15).addBox(0.0f, -5.0f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)2.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        bodyPart.addOrReplaceChild("right_fin", CubeListBuilder.create().texOffs(0, 25).addBox(-3.7071f, 0.7071f, -1.5f, 3.0f, 0.0f, 3.0f), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)-1.0f, (float)1.5708f, (float)0.7854f, (float)0.0f));
        bodyPart.addOrReplaceChild("left_fin", CubeListBuilder.create().mirror().texOffs(0, 25).addBox(0.7071f, 0.7071f, -1.5f, 3.0f, 0.0f, 3.0f), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)-1.0f, (float)1.5708f, (float)-0.7854f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32);
    }

    public EndFishEntityModel(ModelPart modelPart) {
        super(RenderType::entityCutout);
        this.model = modelPart.getChild("body");
        this.fin_top = this.model.getChild("top_fin");
        this.fin_bottom = this.model.getChild("bottom_fin");
        this.flipper = this.model.getChild("tail_fin");
        this.fin_right = this.model.getChild("right_fin");
        this.fin_left = this.model.getChild("left_fin");
    }

    public void setupAnim(EndFishEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float s1 = (float)Math.sin((double)animationProgress * 0.1);
        float s2 = (float)Math.sin((double)animationProgress * 0.05);
        this.flipper.yRot = s1 * 0.3f;
        this.fin_top.xRot = s2 * 0.02f - 0.6981f;
        this.fin_bottom.xRot = 0.6981f - s2 * 0.02f;
        this.fin_left.yRot = s1 * 0.3f - 0.7854f;
        this.fin_right.yRot = 0.7854f - s1 * 0.3f;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.model.render(matrices, vertices, light, overlay);
    }
}

