/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.entity.CubozoaEntity;
import org.betterx.betterend.entity.model.CubozoaEntityModel;
import org.betterx.betterend.registry.EndEntitiesRenders;

public class RendererEntityCubozoa
extends MobRenderer<CubozoaEntity, CubozoaEntityModel> {
    private static final ResourceLocation[] TEXTURE = new ResourceLocation[2];
    private static final RenderType[] GLOW = new RenderType[2];

    public RendererEntityCubozoa(EntityRendererProvider.Context ctx) {
        super(ctx, (EntityModel)new CubozoaEntityModel(ctx.bakeLayer(EndEntitiesRenders.CUBOZOA_MODEL)), 0.5f);
        this.addLayer((RenderLayer)new EyesLayer<CubozoaEntity, CubozoaEntityModel>(this, (RenderLayerParent)this){

            public RenderType renderType() {
                return GLOW[0];
            }

            public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, CubozoaEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
                VertexConsumer vertexConsumer = vertexConsumers.getBuffer(GLOW[entity.getVariant()]);
                ((CubozoaEntityModel)this.getParentModel()).renderToBuffer(matrices, vertexConsumer, 0xF00000, OverlayTexture.NO_OVERLAY, -1);
            }
        });
    }

    protected void scale(CubozoaEntity entity, PoseStack matrixStack, float f) {
        float scale = entity.getScale();
        matrixStack.scale(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(CubozoaEntity entity) {
        return TEXTURE[entity.getVariant()];
    }

    static {
        RendererEntityCubozoa.TEXTURE[0] = BetterEnd.C.mk("textures/entity/cubozoa/cubozoa.png");
        RendererEntityCubozoa.TEXTURE[1] = BetterEnd.C.mk("textures/entity/cubozoa/cubozoa_sulphur.png");
        RendererEntityCubozoa.GLOW[0] = RenderType.eyes((ResourceLocation)BetterEnd.C.mk("textures/entity/cubozoa/cubozoa_glow.png"));
        RendererEntityCubozoa.GLOW[1] = RenderType.eyes((ResourceLocation)BetterEnd.C.mk("textures/entity/cubozoa/cubozoa_sulphur_glow.png"));
    }
}

