/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.mixin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.betterx.betterend.config.Configs;
import org.betterx.betterend.mixin.client.AbstractSoundInstanceAccessor;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.wover.biome.api.BiomeManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MusicManager.class})
public abstract class MusicTrackerMixin {
    @Final
    @Shadow
    private Minecraft minecraft;
    @Final
    @Shadow
    private RandomSource random;
    @Shadow
    private SoundInstance currentMusic;
    @Shadow
    private int nextSongDelay;
    private static float volume = 1.0f;
    private static float srcVolume = 0.0f;
    private static long time;

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void be_onTick(CallbackInfo info) {
        if (((Boolean)Configs.CLIENT_CONFIG.blendBiomeMusic.get()).booleanValue()) {
            Music musicSound = this.minecraft.getSituationalMusic();
            if (this.be_checkNullSound(musicSound) && volume > 0.0f && this.be_shouldChangeSound(musicSound) && this.be_isCorrectBiome()) {
                if (volume > 0.0f) {
                    if (srcVolume < 0.0f) {
                        srcVolume = this.currentMusic.getVolume();
                    }
                    if (this.currentMusic instanceof AbstractSoundInstance) {
                        ((AbstractSoundInstanceAccessor)this.currentMusic).setVolume(volume);
                    }
                    this.minecraft.getSoundManager().updateSourceVolume(this.currentMusic.getSource(), this.currentMusic.getVolume() * volume);
                    long t = System.currentTimeMillis();
                    if (volume == 1.0f && time == 0L) {
                        time = t;
                    }
                    float delta = (float)(t - time) * 5.0E-4f;
                    time = t;
                    if ((volume -= delta) < 0.0f) {
                        volume = 0.0f;
                    }
                }
                if (volume == 0.0f) {
                    volume = 1.0f;
                    time = 0L;
                    srcVolume = -1.0f;
                    this.minecraft.getSoundManager().stop(this.currentMusic);
                    this.nextSongDelay = Mth.nextInt((RandomSource)this.random, (int)0, (int)(musicSound.getMinDelay() / 2));
                    this.currentMusic = null;
                }
                if (this.currentMusic == null && this.nextSongDelay-- <= 0) {
                    this.startPlaying(musicSound);
                }
                info.cancel();
            } else {
                volume = 1.0f;
            }
        }
    }

    private boolean be_isCorrectBiome() {
        if (this.minecraft.level == null) {
            return false;
        }
        Holder biome = this.minecraft.level.getBiome(this.minecraft.player.blockPosition());
        return BiomeManager.biomeDataForHolder((Holder)biome) instanceof EndBiome;
    }

    @Unique
    private boolean be_shouldChangeSound(Music musicSound) {
        return this.currentMusic != null && !((SoundEvent)musicSound.getEvent().value()).getLocation().equals((Object)this.currentMusic.getLocation()) && musicSound.replaceCurrentMusic();
    }

    @Unique
    private boolean be_checkNullSound(Music musicSound) {
        return musicSound != null && musicSound.getEvent() != null;
    }

    @Shadow
    public abstract void startPlaying(Music var1);
}

