/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.mixin.common;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.interfaces.MobEffectApplier;
import org.betterx.betterend.item.CrystaliteArmor;
import org.betterx.betterend.registry.EndAttributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, priority=200)
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private Entity be_lastAttacker;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract AttributeMap getAttributes();

    @Shadow
    public abstract Iterable<ItemStack> getArmorSlots();

    @Inject(method={"createLivingAttributes"}, at={@At(value="RETURN")}, cancellable=true)
    private static void be_addLivingAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> info) {
        EndAttributes.addLivingEntityAttributes((AttributeSupplier.Builder)info.getReturnValue());
    }

    @Inject(method={"tickEffects"}, at={@At(value="HEAD")})
    protected void be_applyEffects(CallbackInfo info) {
        if (!this.level().isClientSide()) {
            LivingEntity owner = (LivingEntity)LivingEntity.class.cast((Object)this);
            if (CrystaliteArmor.hasFullSet(owner)) {
                CrystaliteArmor.applySetEffect(owner);
            }
            this.getArmorSlots().forEach(itemStack -> {
                if (itemStack.getItem() instanceof MobEffectApplier) {
                    ((MobEffectApplier)itemStack.getItem()).applyEffect(owner);
                }
            });
        }
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD")}, cancellable=true)
    public void be_canBeAffected(MobEffectInstance mobEffectInstance, CallbackInfoReturnable<Boolean> info) {
        try {
            if (mobEffectInstance.getEffect() == MobEffects.BLINDNESS && this.getAttributes().getValue(EndAttributes.BLINDNESS_RESISTANCE) > 0.0) {
                info.setReturnValue((Object)false);
            }
        }
        catch (Exception ex) {
            BetterEnd.LOGGER.warn("Blindness resistance attribute haven't been registered.");
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    public void be_hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> info) {
        this.be_lastAttacker = source.getEntity();
    }

    @ModifyArg(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V"), index=0)
    private double be_increaseKnockback(double value, double x, double z) {
        if (this.be_lastAttacker != null && this.be_lastAttacker instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)this.be_lastAttacker;
            value += this.be_getKnockback(attacker.getMainHandItem());
        }
        return value;
    }

    @Unique
    private double be_getKnockback(ItemStack tool) {
        if (tool == null) {
            return 0.0;
        }
        double[] res = new double[]{0.0};
        tool.forEachModifier(EquipmentSlot.MAINHAND, (holder, attributeModifier) -> {
            if (holder.is(Attributes.ATTACK_KNOCKBACK)) {
                res[0] = attributeModifier.amount();
            }
        });
        return res[0];
    }
}

