/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.util.MHelper;

@OnlyIn(value=Dist.CLIENT)
public class ParticleJungleSpore
extends SimpleAnimatedParticle {
    protected ParticleJungleSpore(ClientLevel world, double x, double y, double z, SpriteSet sprites, double r, double g, double b) {
        super(world, x, y, z, sprites, 0.0f);
        this.setSprite(sprites.get(this.random));
        this.lifetime = MHelper.randRange((int)150, (int)300, (RandomSource)this.random);
        this.quadSize = MHelper.randRange((float)0.05f, (float)0.15f, (RandomSource)this.random);
        this.setFadeColor(15916745);
        this.setSpriteFromAge(sprites);
        this.setAlpha(0.0f);
    }

    public void tick() {
        super.tick();
        int ticks = this.age % 30;
        if (ticks == 0) {
            this.xd = this.random.nextGaussian() * 0.02;
            this.yd = (double)this.random.nextFloat() * 0.02 + 0.02;
            this.zd = this.random.nextGaussian() * 0.02;
            ticks = 0;
        }
        if (this.age <= 30) {
            float delta = (float)ticks / 30.0f;
            this.setAlpha(delta);
        } else if (this.age >= this.lifetime) {
            this.setAlpha(0.0f);
        } else if (this.age >= this.lifetime - 30) {
            this.setAlpha((float)(this.lifetime - this.age) / 30.0f);
        } else {
            this.setAlpha(1.0f);
        }
        this.yd -= (double)0.001f;
        this.xd *= (double)0.99f;
        this.zd *= (double)0.99f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FactoryJungleSpore
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public FactoryJungleSpore(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double vX, double vY, double vZ) {
            return new ParticleJungleSpore(world, x, y, z, this.sprites, 1.0, 1.0, 1.0);
        }
    }
}

