/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.util.MHelper;

@OnlyIn(value=Dist.CLIENT)
public class ParticleSnowflake
extends TextureSheetParticle {
    private int ticks;
    private double preVX;
    private double preVY;
    private double preVZ;
    private double nextVX;
    private double nextVY;
    private double nextVZ;

    protected ParticleSnowflake(ClientLevel world, double x, double y, double z, double r, double g, double b, SpriteSet sprites) {
        super(world, x, y, z, r, g, b);
        this.pickSprite(sprites);
        this.lifetime = MHelper.randRange((int)150, (int)300, (RandomSource)this.random);
        this.quadSize = MHelper.randRange((float)0.05f, (float)0.2f, (RandomSource)this.random);
        this.setAlpha(0.0f);
        this.preVX = this.random.nextGaussian() * 0.015;
        this.preVY = this.random.nextGaussian() * 0.015;
        this.preVZ = this.random.nextGaussian() * 0.015;
        this.nextVX = this.random.nextGaussian() * 0.015;
        this.nextVY = this.random.nextGaussian() * 0.015;
        this.nextVZ = this.random.nextGaussian() * 0.015;
    }

    public void tick() {
        ++this.ticks;
        if (this.ticks > 200) {
            this.preVX = this.nextVX;
            this.preVY = this.nextVY;
            this.preVZ = this.nextVZ;
            this.nextVX = this.random.nextGaussian() * 0.015;
            this.nextVY = this.random.nextGaussian() * 0.015;
            this.nextVZ = this.random.nextGaussian() * 0.015;
            if (this.random.nextInt(4) == 0) {
                this.nextVY = Math.abs(this.nextVY);
            }
            this.ticks = 0;
        }
        double delta = (double)this.ticks / 200.0;
        if (this.age <= 40) {
            this.setAlpha((float)this.age / 40.0f);
        } else if (this.age >= this.lifetime - 40) {
            this.setAlpha((float)(this.lifetime - this.age) / 40.0f);
        }
        if (this.age >= this.lifetime) {
            this.remove();
        }
        this.xd = Mth.lerp((double)delta, (double)this.preVX, (double)this.nextVX);
        this.yd = Mth.lerp((double)delta, (double)this.preVY, (double)this.nextVY);
        this.zd = Mth.lerp((double)delta, (double)this.preVZ, (double)this.nextVZ);
        super.tick();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FactorySnowflake
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public FactorySnowflake(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double vX, double vY, double vZ) {
            return new ParticleSnowflake(world, x, y, z, 1.0, 1.0, 1.0, this.sprites);
        }
    }
}

