/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.util.MHelper;

@OnlyIn(value=Dist.CLIENT)
public class SmaragdantParticle
extends SimpleAnimatedParticle {
    private double preVX;
    private double preVY;
    private double preVZ;
    private double nextVX;
    private double nextVY;
    private double nextVZ;

    protected SmaragdantParticle(ClientLevel world, double x, double y, double z, double r, double g, double b, SpriteSet sprites) {
        super(world, x, y, z, sprites, 0.0f);
        this.setSprite(sprites.get(this.random));
        this.lifetime = MHelper.randRange((int)60, (int)120, (RandomSource)this.random);
        this.quadSize = MHelper.randRange((float)0.05f, (float)0.15f, (RandomSource)this.random);
        this.setColor(1.0f, 1.0f, 1.0f);
        this.setAlpha(0.0f);
        this.preVX = this.random.nextGaussian() * 0.01;
        this.preVY = this.random.nextGaussian() * 0.01;
        this.preVZ = this.random.nextGaussian() * 0.01;
        this.nextVX = this.random.nextGaussian() * 0.01;
        this.nextVY = this.random.nextGaussian() * 0.01;
        this.nextVZ = this.random.nextGaussian() * 0.01;
    }

    public void tick() {
        int ticks = this.age & 0x1F;
        if (ticks == 0) {
            this.preVX = this.nextVX;
            this.preVY = this.nextVY;
            this.preVZ = this.nextVZ;
            this.nextVX = this.random.nextGaussian() * 0.015;
            this.nextVY = (double)this.random.nextFloat() * 0.02 + 0.01;
            this.nextVZ = this.random.nextGaussian() * 0.015;
        }
        double delta = (double)ticks / 31.0;
        if (this.age <= 31) {
            this.setAlpha((float)this.age / 31.0f);
        } else if (this.age >= this.lifetime - 31) {
            this.setAlpha((float)(this.lifetime - this.age) / 31.0f);
        }
        if (this.age >= this.lifetime) {
            this.remove();
        }
        this.xd = Mth.lerp((double)delta, (double)this.preVX, (double)this.nextVX);
        this.yd = Mth.lerp((double)delta, (double)this.preVY, (double)this.nextVY);
        this.zd = Mth.lerp((double)delta, (double)this.preVZ, (double)this.nextVZ);
        super.tick();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SmaragdantParticleFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public SmaragdantParticleFactory(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double vX, double vY, double vZ) {
            return new SmaragdantParticle(world, x, y, z, 1.0, 1.0, 1.0, this.sprites);
        }
    }
}

