/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.portal;

import com.google.common.collect.Sets;
import java.awt.Point;
import java.util.Optional;
import java.util.Set;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.EndPortalBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndPoiTypes;
import org.betterx.betterend.rituals.EternalRitual;

public class PortalBuilder {
    public static final Set<Point> FRAME_POSITIONS = Sets.newHashSet((Object[])new Point[]{new Point(0, 0), new Point(0, 6), new Point(1, 0), new Point(1, 6), new Point(2, 1), new Point(2, 5), new Point(3, 2), new Point(3, 3), new Point(3, 4)});
    public static final Set<Point> PORTAL_POSITIONS = Sets.newHashSet((Object[])new Point[]{new Point(0, 0), new Point(0, 1), new Point(0, 2), new Point(0, 3), new Point(0, 4), new Point(1, 0), new Point(1, 1), new Point(1, 2), new Point(1, 3), new Point(1, 4), new Point(2, 1), new Point(2, 2), new Point(2, 3)});
    private static final Set<Point> BASE_POSITIONS = Sets.newHashSet((Object[])new Point[]{new Point(3, 0), new Point(2, 0), new Point(2, 1), new Point(1, 1), new Point(1, 2), new Point(0, 1), new Point(0, 2)});
    private static final Block BASE = EndBlocks.FLAVOLITE.tiles;
    public static final Block FRAME = EndBlocks.FLAVOLITE_RUNED_ETERNAL;
    public static final Block PORTAL = EndBlocks.END_PORTAL_BLOCK;
    public static int SPIRAL_SEARCH_RADIUS = 128;
    private final ServerLevel targetLevel;
    private final Level sourceLevel;

    public PortalBuilder(Level sourceLevel, ServerLevel targetLevel) {
        this.targetLevel = targetLevel;
        this.sourceLevel = sourceLevel;
    }

    public static void generatePortal(Level world, BlockPos center, Direction.Axis axis, int portalId) {
        BlockPos framePos = center.below();
        Direction moveDir = Direction.Axis.X == axis ? Direction.EAST : Direction.NORTH;
        BlockState frame = (BlockState)FRAME.defaultBlockState().setValue((Property)EternalRitual.ACTIVE, (Comparable)Boolean.valueOf(true));
        FRAME_POSITIONS.forEach(point -> {
            BlockPos.MutableBlockPos pos = framePos.mutable().move(moveDir, point.x).move(Direction.UP, point.y);
            world.setBlockAndUpdate((BlockPos)pos, frame);
            pos = framePos.mutable().move(moveDir, -point.x).move(Direction.UP, point.y);
            world.setBlockAndUpdate((BlockPos)pos, frame);
        });
        BlockState portal = (BlockState)((BlockState)PORTAL.defaultBlockState().setValue((Property)EndPortalBlock.AXIS, (Comparable)axis)).setValue((Property)EndPortalBlock.PORTAL, (Comparable)Integer.valueOf(portalId));
        PORTAL_POSITIONS.forEach(point -> {
            BlockPos.MutableBlockPos pos = center.mutable().move(moveDir, point.x).move(Direction.UP, point.y);
            world.setBlockAndUpdate((BlockPos)pos, portal);
            pos = center.mutable().move(moveDir, -point.x).move(Direction.UP, point.y);
            world.setBlockAndUpdate((BlockPos)pos, portal);
        });
        PortalBuilder.generateBase(world, framePos, moveDir);
    }

    private static void generateBase(Level world, BlockPos center, Direction moveX) {
        BlockState base = BASE.defaultBlockState();
        Direction moveY = moveX.getClockWise();
        BASE_POSITIONS.forEach(point -> {
            BlockPos.MutableBlockPos pos = center.mutable().move(moveX, point.x).move(moveY, point.y);
            world.setBlockAndUpdate((BlockPos)pos, base);
            pos = center.mutable().move(moveX, -point.x).move(moveY, point.y);
            world.setBlockAndUpdate((BlockPos)pos, base);
            pos = center.mutable().move(moveX, point.x).move(moveY, -point.y);
            world.setBlockAndUpdate((BlockPos)pos, base);
            pos = center.mutable().move(moveX, -point.x).move(moveY, -point.y);
            world.setBlockAndUpdate((BlockPos)pos, base);
        });
    }

    public static boolean checkIsAreaValid(Level world, BlockPos pos, Direction.Axis axis) {
        if (pos.getY() >= world.getHeight() - 1) {
            return false;
        }
        if (!PortalBuilder.isBaseValid(world, pos, axis)) {
            return false;
        }
        return PortalBuilder.checkArea(world, pos, axis);
    }

    private static boolean isBaseValid(Level world, BlockPos pos, Direction.Axis axis) {
        boolean solid = true;
        if (axis.equals((Object)Direction.Axis.X)) {
            pos = pos.below().offset(0, 0, -3);
            for (int i = 0; i < 7; ++i) {
                BlockPos checkPos = pos.offset(0, 0, i);
                BlockState state = world.getBlockState(checkPos);
                solid &= PortalBuilder.validBlock(world, checkPos, state);
            }
        } else {
            pos = pos.below().offset(-3, 0, 0);
            for (int i = 0; i < 7; ++i) {
                BlockPos checkPos = pos.offset(i, 0, 0);
                BlockState state = world.getBlockState(checkPos);
                solid &= PortalBuilder.validBlock(world, checkPos, state);
            }
        }
        return solid;
    }

    private static boolean validBlock(Level world, BlockPos pos, BlockState state) {
        return state.isRedstoneConductor((BlockGetter)world, pos) && state.isCollisionShapeFullBlock((BlockGetter)world, pos);
    }

    public static boolean checkArea(Level world, BlockPos center, Direction.Axis axis) {
        Direction moveDir = Direction.Axis.X == axis ? Direction.NORTH : Direction.EAST;
        for (BlockPos checkPos : BlockPos.betweenClosed((BlockPos)center.relative(moveDir.getClockWise()), (BlockPos)center.relative(moveDir.getCounterClockWise()))) {
            for (Point point : PORTAL_POSITIONS) {
                BlockPos.MutableBlockPos pos = checkPos.mutable().move(moveDir, point.x).move(Direction.UP, point.y);
                BlockState state = world.getBlockState((BlockPos)pos);
                if (PortalBuilder.isStateInvalid(state)) {
                    return false;
                }
                pos = checkPos.mutable().move(moveDir, -point.x).move(Direction.UP, point.y);
                state = world.getBlockState((BlockPos)pos);
                if (!PortalBuilder.isStateInvalid(state)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isStateInvalid(BlockState state) {
        if (!state.getFluidState().isEmpty()) {
            return true;
        }
        return BlocksHelper.replaceableOrPlant((BlockState)state) == false;
    }

    public Optional<FoundPortalRect> findPortalAround(BlockPos blockPos, WorldBorder worldBorder) {
        PoiManager poiManager = this.targetLevel.getPoiManager();
        poiManager.ensureLoadedAndValid((LevelReader)this.targetLevel, blockPos, SPIRAL_SEARCH_RADIUS);
        if (EndPoiTypes.ETERNAL_PORTAL == null) {
            return Optional.empty();
        }
        Optional oPos = EndPoiTypes.ETERNAL_PORTAL.findPoiAround(this.targetLevel, blockPos, SPIRAL_SEARCH_RADIUS, worldBorder);
        return oPos.map(poiPos -> {
            this.targetLevel.getChunkSource().addRegionTicket(TicketType.PORTAL, new ChunkPos(poiPos), 3, poiPos);
            BlockState blockState = this.targetLevel.getBlockState(poiPos);
            return new FoundPortalRect(BlockUtil.getLargestRectangleAround((BlockPos)poiPos, (Direction.Axis)((Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, bp -> this.targetLevel.getBlockState(bp) == blockState), (BlockPos)poiPos);
        });
    }

    public static BlockPos getStartingPos(Level sourceLevel, Level targetLevel, Entity entity, WorldBorder worldBorder) {
        double dimensionScale = DimensionType.getTeleportationScale((DimensionType)sourceLevel.dimensionType(), (DimensionType)targetLevel.dimensionType());
        return worldBorder.clampToBounds(entity.getX() * dimensionScale, entity.getY(), entity.getZ() * dimensionScale);
    }

    public Optional<BlockPos> createPortal(BlockPos startPosition, Direction.Axis axis, int portalID) {
        Direction portalDirection = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d = -1.0;
        BlockPos centerPos = null;
        double e = -1.0;
        BlockPos blockPos3 = null;
        WorldBorder worldBorder = this.targetLevel.getWorldBorder();
        int maxHeight = Math.min(this.targetLevel.getMaxBuildHeight(), this.targetLevel.getMinBuildHeight() + this.targetLevel.getLogicalHeight()) - 1;
        BlockPos.MutableBlockPos currentPos = startPosition.mutable();
        for (BlockPos.MutableBlockPos testPosition : BlockPos.spiralAround((BlockPos)startPosition, (int)SPIRAL_SEARCH_RADIUS, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int levelHeight = Math.min(maxHeight, this.targetLevel.getHeight(Heightmap.Types.MOTION_BLOCKING, testPosition.getX(), testPosition.getZ()));
            if (!worldBorder.isWithinBounds((BlockPos)testPosition) || !worldBorder.isWithinBounds((BlockPos)testPosition.move(portalDirection, 1))) continue;
            testPosition.move(portalDirection.getOpposite(), 1);
            for (int yy = levelHeight; yy >= this.targetLevel.getMinBuildHeight(); --yy) {
                int n;
                testPosition.setY(yy);
                if (!this.canPortalReplaceBlock((BlockPos)testPosition)) continue;
                int startY = yy;
                while (yy > this.targetLevel.getMinBuildHeight() && this.canPortalReplaceBlock((BlockPos)testPosition.move(Direction.DOWN))) {
                    --yy;
                }
                if (yy + 4 > maxHeight || (n = startY - yy) > 0 && n < 3) continue;
                testPosition.setY(yy);
                if (!this.canHostFrame((BlockPos)testPosition, currentPos, portalDirection, 0)) continue;
                double f = startPosition.distSqr((Vec3i)testPosition);
                if (this.canHostFrame((BlockPos)testPosition, currentPos, portalDirection, -1) && this.canHostFrame((BlockPos)testPosition, currentPos, portalDirection, 1) && (d == -1.0 || d > f)) {
                    d = f;
                    centerPos = testPosition.immutable();
                }
                if (d != -1.0 || e != -1.0 && !(e > f)) continue;
                e = f;
                blockPos3 = testPosition.immutable();
            }
        }
        if (d == -1.0 && e != -1.0) {
            centerPos = blockPos3;
            d = e;
        }
        if (d == -1.0) {
            int p = maxHeight - 9;
            int o = Math.max(this.targetLevel.getMinBuildHeight() - -1, 70);
            if (p < o) {
                return Optional.empty();
            }
            centerPos = new BlockPos(startPosition.getX(), Mth.clamp((int)startPosition.getY(), (int)o, (int)p), startPosition.getZ()).immutable();
            if (!worldBorder.isWithinBounds(centerPos)) {
                return Optional.empty();
            }
        }
        this.buildPortal(portalDirection, centerPos, portalID);
        return Optional.of(centerPos.immutable());
    }

    private void buildPortal(Direction portalDirection, BlockPos centerPos, int portalID) {
        Direction.Axis portalAxis = Direction.Axis.X == portalDirection.getAxis() ? Direction.Axis.Z : Direction.Axis.X;
        PortalBuilder.generatePortal((Level)this.targetLevel, centerPos, portalAxis, portalID);
    }

    private int getPortalID(BlockPos portalEntrancePos) {
        BlockState currentState = this.sourceLevel.getBlockState(portalEntrancePos);
        int portalID = currentState.hasProperty((Property)EndPortalBlock.PORTAL) ? (Integer)currentState.getValue((Property)EndPortalBlock.PORTAL) : -1;
        return portalID;
    }

    private boolean canPortalReplaceBlock(BlockPos currentPos) {
        BlockState blockState = this.targetLevel.getBlockState(currentPos);
        return blockState.canBeReplaced() && blockState.getFluidState().isEmpty();
    }

    private boolean canHostFrame(BlockPos pos, BlockPos.MutableBlockPos currentPos, Direction direction, int widthScale) {
        Direction orthogonalDir = direction.getClockWise();
        for (int x = -1; x < 3; ++x) {
            for (int y = -1; y < 4; ++y) {
                currentPos.setWithOffset((Vec3i)pos, direction.getStepX() * x + orthogonalDir.getStepX() * widthScale, y, direction.getStepZ() * x + orthogonalDir.getStepZ() * widthScale);
                if (y < 0 && !this.targetLevel.getBlockState((BlockPos)currentPos).isSolid()) {
                    return false;
                }
                if (y < 0 || this.canPortalReplaceBlock((BlockPos)currentPos)) continue;
                return false;
            }
        }
        return true;
    }

    public record FoundPortalRect(BlockUtil.FoundRectangle rect, BlockPos pos) {
    }
}

