/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.recipe.builders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.interfaces.UnknownReceipBookCategory;
import org.betterx.bclib.recipes.BCLBaseRecipeBuilder;
import org.betterx.bclib.recipes.BCLRecipeManager;
import org.betterx.bclib.util.ItemUtil;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.rituals.InfusionRitual;
import org.betterx.wover.enchantment.api.EnchantmentUtils;
import org.betterx.wover.item.api.ItemStackHelper;
import org.betterx.wover.recipe.api.BaseRecipeBuilder;
import org.betterx.wover.recipe.api.BaseUnlockableRecipeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfusionRecipe
implements Recipe<InfusionRitual.InfusionInput>,
UnknownReceipBookCategory {
    public static final String GROUP = "infusion";
    public static final RecipeType<InfusionRecipe> TYPE = BCLRecipeManager.registerType((String)"betterend", (String)"infusion");
    public static final Serializer SERIALIZER = (Serializer)BCLRecipeManager.registerSerializer((String)"betterend", (String)"infusion", (RecipeSerializer)new Serializer());
    private final Ingredient[] catalysts;
    private final Ingredient input;
    private final ItemStack output;
    private final int time;
    private final String group;

    private InfusionRecipe(Ingredient input, ItemStack output, Ingredient[] catalysts, int time, String group) {
        this.input = input;
        this.output = ItemStackHelper.callItemStackSetupIfPossible((ItemStack)output);
        this.catalysts = catalysts;
        this.time = time;
        this.group = group;
    }

    public static Builder create(String id, ItemLike output) {
        return InfusionRecipe.create(BetterEnd.C.mk(id), output);
    }

    public static Builder create(ResourceLocation id, ItemLike output) {
        return new BuilderImpl(id, output);
    }

    public static Builder create(String id, ItemStack output) {
        return InfusionRecipe.create(BetterEnd.C.mk(id), output);
    }

    public static Builder create(ResourceLocation id, ItemStack output) {
        return new BuilderImpl(id, output);
    }

    public static Builder create(String id, ResourceKey<Enchantment> enchantment, int level, HolderLookup.RegistryLookup<Enchantment> lookup) {
        return InfusionRecipe.create(BetterEnd.C.mk(id), enchantment, level, lookup);
    }

    public static Builder create(ResourceLocation id, ResourceKey<Enchantment> enchantment, int level, HolderLookup.RegistryLookup<Enchantment> lookup) {
        return new BuilderImpl(id, InfusionRecipe.createEnchantedBook(enchantment, level, lookup));
    }

    public static ItemStack createEnchantedBook(ResourceKey<Enchantment> enchantment, int level, HolderLookup.RegistryLookup<Enchantment> lookup) {
        Holder holder = EnchantmentUtils.getEnchantment(lookup, enchantment);
        ItemStack stack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        if (holder != null) {
            stack.enchant(holder, level);
        }
        return stack;
    }

    public int getInfusionTime() {
        return this.time;
    }

    public boolean matches(InfusionRitual.InfusionInput inv, Level world) {
        boolean valid = this.input.test(inv.getItem(0));
        if (!valid) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            valid &= this.catalysts[i].test(inv.getItem(i + 1));
        }
        return valid;
    }

    @NotNull
    public ItemStack assemble(InfusionRitual.InfusionInput recipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList defaultedList = NonNullList.create();
        defaultedList.add((Object)this.input);
        defaultedList.addAll(Arrays.asList(this.catalysts));
        return defaultedList;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider acc) {
        return this.output;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public String getGroup() {
        return this.group;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public RecipeType<?> getType() {
        return TYPE;
    }

    public static void register() {
    }

    public static interface Builder
    extends BaseRecipeBuilder<Builder>,
    BaseUnlockableRecipeBuilder<Builder> {
        public Builder group(@Nullable String var1);

        public Builder setPrimaryInput(ItemLike ... var1);

        public Builder setPrimaryInput(TagKey<Item> var1);

        public Builder setPrimaryInputAndUnlock(TagKey<Item> var1);

        public Builder setPrimaryInputAndUnlock(ItemLike ... var1);

        public Builder setTime(int var1);

        public Builder addCatalyst(CatalystSlot var1, ItemLike ... var2);

        public Builder addCatalyst(CatalystSlot var1, ItemStack var2);

        public Builder addCatalyst(CatalystSlot var1, TagKey<Item> var2);
    }

    public static class BuilderImpl
    extends BCLBaseRecipeBuilder<Builder, InfusionRecipe>
    implements Builder {
        private final Ingredient[] catalysts = new Ingredient[]{Ingredient.EMPTY, Ingredient.EMPTY, Ingredient.EMPTY, Ingredient.EMPTY, Ingredient.EMPTY, Ingredient.EMPTY, Ingredient.EMPTY, Ingredient.EMPTY};
        private int time = 1;

        protected BuilderImpl(ResourceLocation id, ItemLike output) {
            this(id, new ItemStack(output, 1));
        }

        protected BuilderImpl(ResourceLocation id, ItemStack output) {
            super(id, output, false);
        }

        @Override
        public Builder setTime(int time) {
            this.time = time;
            return this;
        }

        @Override
        public Builder addCatalyst(CatalystSlot slot, ItemLike ... items) {
            this.catalysts[slot.index] = Ingredient.of((ItemLike[])items);
            return this;
        }

        @Override
        public Builder addCatalyst(CatalystSlot slot, ItemStack stack) {
            this.catalysts[slot.index] = Ingredient.of((ItemStack[])new ItemStack[]{stack});
            return this;
        }

        @Override
        public Builder addCatalyst(CatalystSlot slot, TagKey<Item> tag) {
            this.catalysts[slot.index] = Ingredient.of(tag);
            return this;
        }

        protected void validate() {
            super.validate();
            if (this.time < 0) {
                this.throwIllegalStateException("Time should be positive, recipe {} will be ignored!");
            }
        }

        protected InfusionRecipe createRecipe(ResourceLocation id) {
            return new InfusionRecipe(this.primaryInput, this.output, this.catalysts, this.time, this.group);
        }
    }

    public static class Serializer
    implements RecipeSerializer<InfusionRecipe> {
        public static final MapCodec<Ingredient[]> CODEC_CATALYSTS = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemUtil.CODEC_INGREDIENT_WITH_NBT.lenientOptionalFieldOf(CatalystSlot.NORTH.key, (Object)Ingredient.EMPTY).forGetter(catalysts -> catalysts[CatalystSlot.NORTH.index]), (App)ItemUtil.CODEC_INGREDIENT_WITH_NBT.lenientOptionalFieldOf(CatalystSlot.NORTH_EAST.key, (Object)Ingredient.EMPTY).forGetter(catalysts -> catalysts[CatalystSlot.NORTH_EAST.index]), (App)ItemUtil.CODEC_INGREDIENT_WITH_NBT.lenientOptionalFieldOf(CatalystSlot.EAST.key, (Object)Ingredient.EMPTY).forGetter(catalysts -> catalysts[CatalystSlot.EAST.index]), (App)ItemUtil.CODEC_INGREDIENT_WITH_NBT.lenientOptionalFieldOf(CatalystSlot.SOUTH_EAST.key, (Object)Ingredient.EMPTY).forGetter(catalysts -> catalysts[CatalystSlot.SOUTH_EAST.index]), (App)ItemUtil.CODEC_INGREDIENT_WITH_NBT.lenientOptionalFieldOf(CatalystSlot.SOUTH.key, (Object)Ingredient.EMPTY).forGetter(catalysts -> catalysts[CatalystSlot.SOUTH.index]), (App)ItemUtil.CODEC_INGREDIENT_WITH_NBT.lenientOptionalFieldOf(CatalystSlot.SOUTH_WEST.key, (Object)Ingredient.EMPTY).forGetter(catalysts -> catalysts[CatalystSlot.SOUTH_WEST.index]), (App)ItemUtil.CODEC_INGREDIENT_WITH_NBT.lenientOptionalFieldOf(CatalystSlot.WEST.key, (Object)Ingredient.EMPTY).forGetter(catalysts -> catalysts[CatalystSlot.WEST.index]), (App)ItemUtil.CODEC_INGREDIENT_WITH_NBT.lenientOptionalFieldOf(CatalystSlot.NORTH_WEST.key, (Object)Ingredient.EMPTY).forGetter(catalysts -> catalysts[CatalystSlot.NORTH_WEST.index])).apply((Applicative)instance, (n, ne, e, se, s, sw, w, nw) -> new Ingredient[]{n, ne, e, se, s, sw, w, nw}));
        public static final MapCodec<InfusionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemUtil.CODEC_INGREDIENT_WITH_NBT.fieldOf("input").forGetter(recipe -> recipe.input), (App)ItemUtil.CODEC_ITEM_STACK_WITH_NBT.fieldOf("result").forGetter(recipe -> recipe.output), (App)CODEC_CATALYSTS.fieldOf("catalysts").forGetter(recipe -> recipe.catalysts), (App)Codec.INT.optionalFieldOf("time", (Object)1).forGetter(recipe -> recipe.time), (App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group)).apply((Applicative)instance, InfusionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InfusionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public static InfusionRecipe fromNetwork(RegistryFriendlyByteBuf packetBuffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)packetBuffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)packetBuffer);
            String group = packetBuffer.readUtf();
            int time = packetBuffer.readVarInt();
            Ingredient[] catalysts = new Ingredient[8];
            for (int i = 0; i < 8; ++i) {
                catalysts[i] = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)packetBuffer);
            }
            return new InfusionRecipe(input, output, catalysts, time, group);
        }

        public static void toNetwork(RegistryFriendlyByteBuf packetBuffer, InfusionRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)packetBuffer, (Object)recipe.input);
            ItemStack.STREAM_CODEC.encode((Object)packetBuffer, (Object)recipe.output);
            packetBuffer.writeUtf(recipe.group);
            packetBuffer.writeVarInt(recipe.time);
            for (int i = 0; i < 8; ++i) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)packetBuffer, (Object)recipe.catalysts[i]);
            }
        }

        @NotNull
        public MapCodec<InfusionRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, InfusionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static enum CatalystSlot implements StringRepresentable
    {
        NORTH(0, "north"),
        NORTH_EAST(1, "north_east"),
        EAST(2, "east"),
        SOUTH_EAST(3, "south_east"),
        SOUTH(4, "south"),
        SOUTH_WEST(5, "south_west"),
        WEST(6, "west"),
        NORTH_WEST(7, "north_west");

        public static final Codec<CatalystSlot> CODEC;
        public final int index;
        public final String key;

        private CatalystSlot(int index, String key) {
            this.index = index;
            this.key = key;
        }

        @NotNull
        public String getSerializedName() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.fromEnum(CatalystSlot::values);
        }
    }
}

