/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.registry;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.bclib.api.v2.spawning.SpawnRuleBuilder;
import org.betterx.bclib.entity.BCLEntityWrapper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.entity.CubozoaEntity;
import org.betterx.betterend.entity.DragonflyEntity;
import org.betterx.betterend.entity.EndFishEntity;
import org.betterx.betterend.entity.EndSlimeEntity;
import org.betterx.betterend.entity.ShadowWalkerEntity;
import org.betterx.betterend.entity.SilkMothEntity;
import org.betterx.betterend.registry.EndItems;
import org.betterx.ui.ColorUtil;

public class EndEntities {
    public static final ResourceLocation DRAGONFLY_ID = BetterEnd.C.mk("dragonfly");
    public static final ResourceLocation END_SLIME_ID = BetterEnd.C.mk("end_slime");
    public static final ResourceLocation END_FISH_ID = BetterEnd.C.mk("end_fish");
    public static final ResourceLocation SHADOW_WALKER_ID = BetterEnd.C.mk("shadow_walker");
    public static final ResourceLocation CUBOZOA_ID = BetterEnd.C.mk("cubozoa");
    public static final ResourceLocation SILK_MOTH_ID = BetterEnd.C.mk("silk_moth");
    private static final EntityType<DragonflyEntity> DRAGONFLY_TYPE = EndEntities.buildEntityType(DragonflyEntity::new, MobCategory.AMBIENT, 0.6f, 0.5f, DRAGONFLY_ID);
    private static final EntityType<EndSlimeEntity> END_SLIME_TYPE = EndEntities.buildEntityType(EndSlimeEntity::new, MobCategory.MONSTER, 0.5f, 0.5f, END_SLIME_ID);
    private static final EntityType<EndFishEntity> END_FISH_TYPE = EndEntities.buildEntityType(EndFishEntity::new, MobCategory.WATER_AMBIENT, 0.5f, 0.5f, END_FISH_ID);
    private static final EntityType<ShadowWalkerEntity> SHADOW_WALKER_TYPE = EndEntities.buildEntityType(ShadowWalkerEntity::new, MobCategory.MONSTER, 0.6f, 1.95f, SHADOW_WALKER_ID);
    private static final EntityType<CubozoaEntity> CUBOZOA_TYPE = EndEntities.buildEntityType(CubozoaEntity::new, MobCategory.WATER_AMBIENT, 0.6f, 1.0f, CUBOZOA_ID);
    private static final EntityType<SilkMothEntity> SILK_MOTH_TYPE = EndEntities.buildEntityType(SilkMothEntity::new, MobCategory.AMBIENT, 0.6f, 0.6f, SILK_MOTH_ID);
    public static final BCLEntityWrapper<DragonflyEntity> DRAGONFLY = new BCLEntityWrapper(DRAGONFLY_TYPE, true);
    public static final BCLEntityWrapper<EndSlimeEntity> END_SLIME = new BCLEntityWrapper(END_SLIME_TYPE, true);
    public static final BCLEntityWrapper<EndFishEntity> END_FISH = new BCLEntityWrapper(END_FISH_TYPE, true);
    public static final BCLEntityWrapper<ShadowWalkerEntity> SHADOW_WALKER = new BCLEntityWrapper(SHADOW_WALKER_TYPE, true);
    public static final BCLEntityWrapper<CubozoaEntity> CUBOZOA = new BCLEntityWrapper(CUBOZOA_TYPE, true);
    public static final BCLEntityWrapper<SilkMothEntity> SILK_MOTH = new BCLEntityWrapper(SILK_MOTH_TYPE, true);
    private static final Map<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> ATTR_BUILDERS = Maps.newHashMap();

    public static void onRegister(RegisterEvent event) {
        if (!event.getRegistryKey().equals(Registries.ENTITY_TYPE)) {
            return;
        }
        event.register(Registries.ENTITY_TYPE, helper -> {
            EndEntities.registerMob(helper, DRAGONFLY_ID, DRAGONFLY_TYPE, DragonflyEntity.createMobAttributes(), ColorUtil.color((int)32, (int)42, (int)176), ColorUtil.color((int)115, (int)225, (int)249));
            EndEntities.registerMob(helper, END_SLIME_ID, END_SLIME_TYPE, EndSlimeEntity.createMobAttributes(), ColorUtil.color((int)28, (int)28, (int)28), ColorUtil.color((int)99, (int)11, (int)99));
            EndEntities.registerMob(helper, END_FISH_ID, END_FISH_TYPE, EndFishEntity.createMobAttributes(), ColorUtil.color((int)3, (int)50, (int)76), ColorUtil.color((int)120, (int)206, (int)255));
            EndEntities.registerMob(helper, SHADOW_WALKER_ID, SHADOW_WALKER_TYPE, ShadowWalkerEntity.createMobAttributes(), ColorUtil.color((int)30, (int)30, (int)30), ColorUtil.color((int)5, (int)5, (int)5));
            EndEntities.registerMob(helper, CUBOZOA_ID, CUBOZOA_TYPE, CubozoaEntity.createMobAttributes(), ColorUtil.color((int)151, (int)77, (int)181), ColorUtil.color((int)93, (int)176, (int)238));
            EndEntities.registerMob(helper, SILK_MOTH_ID, SILK_MOTH_TYPE, SilkMothEntity.createMobAttributes(), ColorUtil.color((int)198, (int)138, (int)204), ColorUtil.color((int)242, (int)220, (int)236));
            EndEntities.setupSpawnRules();
        });
    }

    public static void onRegisterAttributes(EntityAttributeCreationEvent event) {
        ATTR_BUILDERS.forEach((type, builder) -> event.put(type, builder.build()));
    }

    public static void register() {
        EndEntities.setupSpawnRules();
    }

    private static void setupSpawnRules() {
        if (DRAGONFLY == null || SILK_MOTH == null || END_SLIME == null || SHADOW_WALKER == null || END_FISH == null || CUBOZOA == null) {
            return;
        }
        SpawnRuleBuilder.start(DRAGONFLY).aboveGround(2).maxNearby(4, 32).buildNoRestrictions(Heightmap.Types.MOTION_BLOCKING);
        SpawnRuleBuilder.start(SILK_MOTH).aboveGround(2).maxNearby(4, 32).buildNoRestrictions(Heightmap.Types.MOTION_BLOCKING);
        SpawnRuleBuilder.start(END_SLIME).notPeaceful().maxNearby(6, 32).onlyOnValidBlocks().customRule(EndSlimeEntity::canSpawn).buildOnGround(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
        SpawnRuleBuilder.start(SHADOW_WALKER).vanillaHostile().onlyOnValidBlocks().maxNearby(8, 64).buildOnGround(Heightmap.Types.MOTION_BLOCKING);
        SpawnRuleBuilder.start(END_FISH).maxNearby(16, 16).buildInWater(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
        SpawnRuleBuilder.start(CUBOZOA).maxNearby(16, 16).buildInWater(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    }

    private static <T extends Mob> void registerMob(RegisterEvent.RegisterHelper<EntityType<?>> helper, ResourceLocation id, EntityType<T> type, AttributeSupplier.Builder attributes, int eggColor, int dotsColor) {
        EndEntities.registerAttribute(type, attributes);
        EndItems.registerEndEgg("spawn_egg_" + id.getPath(), type, eggColor, dotsColor);
        helper.register(id, type);
    }

    private static <T extends Mob> EntityType<T> buildEntityType(EntityType.EntityFactory<T> factory, MobCategory category, float width, float height, ResourceLocation id) {
        return EntityType.Builder.of(factory, (MobCategory)category).sized(width, height).build(id.toString());
    }

    private static void registerAttribute(EntityType<? extends LivingEntity> entity, AttributeSupplier.Builder builder) {
        ATTR_BUILDERS.put(entity, builder);
    }
}

