/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.registry;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.RunedFlavolite;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.poi.api.PoiManager;
import org.betterx.wover.poi.api.WoverPoiType;

public class EndPoiTypes {
    public static WoverPoiType ETERNAL_PORTAL;
    public static WoverPoiType ETERNAL_PORTAL_FRAME;

    public static void register() {
        if (ETERNAL_PORTAL == null && EndBlocks.END_PORTAL_BLOCK != null && (ETERNAL_PORTAL = EndPoiTypes.resolveExistingPoiType(EndBlocks.END_PORTAL_BLOCK)) == null) {
            try {
                ETERNAL_PORTAL = PoiManager.register((ResourceLocation)BetterEnd.C.mk("eternal_portal"), (Set)ImmutableSet.copyOf((Collection)EndBlocks.END_PORTAL_BLOCK.getStateDefinition().getPossibleStates()), (int)0, (int)1);
            }
            catch (IllegalStateException ex) {
                BetterEnd.C.log.warn("Skip eternal_portal POI registration: {}", new Object[]{ex.getMessage()});
                ETERNAL_PORTAL = EndPoiTypes.resolveExistingPoiType(EndBlocks.END_PORTAL_BLOCK);
            }
        }
        if (ETERNAL_PORTAL_FRAME == null && EndBlocks.FLAVOLITE_RUNED_ETERNAL != null && (ETERNAL_PORTAL_FRAME = EndPoiTypes.resolveExistingPoiType(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) == null) {
            try {
                ETERNAL_PORTAL_FRAME = PoiManager.register((ResourceLocation)BetterEnd.C.mk("eternal_portal_frame"), Set.of((BlockState)EndBlocks.FLAVOLITE_RUNED_ETERNAL.defaultBlockState().setValue((Property)RunedFlavolite.ACTIVATED, (Comparable)Boolean.valueOf(false))), (int)0, (int)1);
            }
            catch (IllegalStateException ex) {
                BetterEnd.C.log.warn("Skip eternal_portal_frame POI registration: {}", new Object[]{ex.getMessage()});
                ETERNAL_PORTAL_FRAME = EndPoiTypes.resolveExistingPoiType(EndBlocks.FLAVOLITE_RUNED_ETERNAL);
            }
        }
    }

    public static void onRegister(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.POINT_OF_INTEREST_TYPE)) {
            EndPoiTypes.register();
        }
    }

    private static WoverPoiType resolveExistingPoiType(Block block) {
        if (block == null) {
            return null;
        }
        Holder<PoiType> holder = EndPoiTypes.findExistingPoiHolder(block);
        if (holder == null) {
            return null;
        }
        ResourceKey key = holder.unwrapKey().orElse(null);
        if (key == null) {
            return null;
        }
        return new WoverPoiType(key, (PoiType)holder.value(), (Set)ImmutableSet.copyOf((Collection)block.getStateDefinition().getPossibleStates()), 0, 1);
    }

    private static Holder<PoiType> findExistingPoiHolder(Block block) {
        for (BlockState state : block.getStateDefinition().getPossibleStates()) {
            Holder holder = PoiTypes.forState((BlockState)state).orElse(null);
            if (holder == null) continue;
            return holder;
        }
        return null;
    }
}

