/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.biome.cave;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.bclib.util.WeightedList;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.EndBiomeBuilder;
import org.betterx.betterend.world.biome.EndBiomeKey;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.biome.api.data.BiomeGenerationDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadeCaveBiome
extends EndCaveBiome.Config<JadeCaveBiome> {
    public static final MapCodec<Biome> CODEC = EndCaveBiome.simpleCaveBiomeCodec(Biome::new);
    public static final KeyDispatchDataCodec<Biome> KEY_CODEC = KeyDispatchDataCodec.of(CODEC);
    public static final MapCodec<Biome> NETWORK_CODEC = EndCaveBiome.simpleCaveBiomeNetworkCodec(Biome::new);
    public static final KeyDispatchDataCodec<Biome> NETWORK_KEY_CODEC = KeyDispatchDataCodec.of(NETWORK_CODEC);

    public JadeCaveBiome(EndBiomeKey<JadeCaveBiome, ?> key) {
        super(key);
    }

    @Override
    public void addCustomBuildData(EndBiomeBuilder builder) {
        super.addCustomBuildData(builder);
        ((EndBiomeBuilder)((EndBiomeBuilder)builder.fogColor(118, 150, 112)).fogDensity(2.0f)).waterAndFogColor(95, 223, 255);
    }

    @Override
    @NotNull
    public EndBiome instantiateBiome(float fogDensity, BiomeKey<?> key, @NotNull BiomeGenerationDataContainer generatorData, float terrainHeight, float genChance, int edgeSize, boolean vertical, @Nullable ResourceKey<net.minecraft.world.level.biome.Biome> edge, @Nullable ResourceKey<net.minecraft.world.level.biome.Biome> parent, boolean hasCave, SurfaceMaterialProvider surface) {
        return new Biome(fogDensity, (ResourceKey<net.minecraft.world.level.biome.Biome>)key.key, generatorData, terrainHeight, genChance, edgeSize, vertical, edge, parent, hasCave, surface, new WeightedList(), new WeightedList());
    }

    public static class Biome
    extends EndCaveBiome {
        private static final OpenSimplexNoise WALL_NOISE = new OpenSimplexNoise("jade_cave".hashCode());
        private static final OpenSimplexNoise DEPTH_NOISE = new OpenSimplexNoise("depth_noise".hashCode());
        private static final BlockState[] JADE = new BlockState[3];

        public KeyDispatchDataCodec<? extends EndCaveBiome> codec() {
            return KEY_CODEC;
        }

        public KeyDispatchDataCodec<? extends EndCaveBiome> networkCodec() {
            return NETWORK_KEY_CODEC;
        }

        protected Biome(float fogDensity, @NotNull ResourceKey<net.minecraft.world.level.biome.Biome> biome, @NotNull BiomeGenerationDataContainer generatorData, float terrainHeight, float genChance, int edgeSize, boolean vertical, @Nullable ResourceKey<net.minecraft.world.level.biome.Biome> edge, @Nullable ResourceKey<net.minecraft.world.level.biome.Biome> parent, boolean hasCaves, SurfaceMaterialProvider surface, WeightedList<Holder<ConfiguredFeature<?, ?>>> floorFeatures, WeightedList<Holder<ConfiguredFeature<?, ?>>> ceilFeatures) {
            super(fogDensity, biome, generatorData, terrainHeight, genChance, edgeSize, vertical, edge, parent, hasCaves, surface, floorFeatures, ceilFeatures);
        }

        @Override
        public BlockState getWall(BlockPos pos) {
            double depth = DEPTH_NOISE.eval((double)pos.getX() * 0.02, (double)pos.getZ() * 0.02) * 0.2 + 0.5;
            int index = Mth.floor((double)(((double)pos.getY() + WALL_NOISE.eval((double)pos.getX() * 0.2, (double)pos.getZ() * 0.2) * 1.5) * depth + 0.5));
            index = Mth.abs((int)index) % 3;
            return JADE[index];
        }

        static {
            Biome.JADE[0] = EndBlocks.VIRID_JADESTONE.stone.defaultBlockState();
            Biome.JADE[1] = EndBlocks.AZURE_JADESTONE.stone.defaultBlockState();
            Biome.JADE[2] = EndBlocks.SANDY_JADESTONE.stone.defaultBlockState();
        }
    }
}

