/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFSmoothUnion;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.features.EndConfiguredVegetation;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class SpireFeature
extends DefaultFeature {
    protected static final Function<BlockState, Boolean> REPLACE = state -> {
        if (state.is(CommonBlockTags.END_STONES)) {
            return true;
        }
        if (state.getBlock() instanceof LeavesBlock || state.is(BlockTags.LEAVES)) {
            return true;
        }
        return BlocksHelper.replaceableOrPlant((BlockState)state);
    };

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        ChunkGenerator chunkGenerator = featureConfig.chunkGenerator();
        if ((pos = SpireFeature.getPosOnSurfaceWG((WorldGenLevel)world, (BlockPos)pos)).getY() < 10 || !world.getBlockState(pos.below(3)).is(CommonBlockTags.END_STONES) || !world.getBlockState(pos.below(6)).is(CommonBlockTags.END_STONES)) {
            return false;
        }
        SDFPrimitive sdf = new SDFSphere().setRadius((float)MHelper.randRange((int)2, (int)3, (RandomSource)random)).setBlock(Blocks.END_STONE);
        int count = MHelper.randRange((int)3, (int)7, (RandomSource)random);
        for (int i = 0; i < count; ++i) {
            float rMin = (float)i * 1.3f + 2.5f;
            sdf = this.addSegment((SDF)sdf, MHelper.randRange((float)rMin, (float)(rMin + 1.5f), (RandomSource)random), random);
        }
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextLong());
        sdf = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)(Math.abs(noise.eval((double)vec.x() * 0.1, (double)vec.y() * 0.1, (double)vec.z() * 0.1)) * 3.0 + Math.abs(noise.eval((double)vec.x() * 0.3, (double)vec.y() * 0.3 + 100.0, (double)vec.z() * 0.3)) * (double)1.3f))).setSource((SDF)sdf);
        BlockPos center = pos;
        ArrayList support = Lists.newArrayList();
        sdf.setReplaceFunction(REPLACE).addPostProcess(info -> {
            if (info.getStateUp().isAir()) {
                if (random.nextInt(16) == 0) {
                    support.add(info.getPos().above());
                }
                return EndBiome.findTopMaterial(world, info.getPos());
            }
            if (info.getState(Direction.UP, 3).isAir()) {
                return EndBiome.findUnderMaterial(world, info.getPos());
            }
            return info.getState();
        }).fillRecursive((ServerLevelAccessor)world, center);
        support.forEach(bpos -> {
            Holder biome = world.getBiome(bpos);
            if (biome != null && biome.equals(EndBiomes.BLOSSOMING_SPIRES)) {
                EndConfiguredVegetation.TENANEA_BUSH.placeInWorld(world, bpos, random, chunkGenerator);
            }
        });
        return true;
    }

    protected SDF addSegment(SDF sdf, float radius, RandomSource random) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock(Blocks.END_STONE);
        SDFUnary offseted = new SDFTranslate().setTranslate(0.0f, radius + random.nextFloat() * 0.25f * radius, 0.0f).setSource(sdf);
        return new SDFSmoothUnion().setRadius(radius * 0.5f).setSourceA((SDF)sphere).setSourceB((SDF)offseted);
    }
}

