/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.SulphurCrystalBlock;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.util.BlockFixer;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class SulphuricCaveFeature
extends DefaultFeature {
    private static final BlockState CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();
    private static final BlockState WATER = Blocks.WATER.defaultBlockState();
    private static final Direction[] HORIZONTAL = BlocksHelper.makeHorizontal();

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        int radius = MHelper.randRange((int)10, (int)30, (RandomSource)random);
        int top = world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, pos.getX(), pos.getZ());
        BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
        bpos.setX(pos.getX());
        bpos.setZ(pos.getZ());
        bpos.setY(top - 1);
        BlockState state = world.getBlockState((BlockPos)bpos);
        while (!state.is(CommonBlockTags.END_STONES) && bpos.getY() > 5) {
            bpos.setY(bpos.getY() - 1);
            state = world.getBlockState((BlockPos)bpos);
        }
        if (bpos.getY() < 10) {
            return false;
        }
        top = (int)((float)bpos.getY() - ((float)radius * 1.3f + 5.0f));
        while (state.is(CommonBlockTags.END_STONES) || !state.getFluidState().isEmpty() && bpos.getY() > 5) {
            bpos.setY(bpos.getY() - 1);
            state = world.getBlockState((BlockPos)bpos);
        }
        int bottom = (int)((float)bpos.getY() + (float)radius * 1.3f + 5.0f);
        if (top <= bottom) {
            return false;
        }
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        pos = new BlockPos(pos.getX(), MHelper.randRange((int)bottom, (int)top, (RandomSource)random), pos.getZ());
        OpenSimplexNoise noise = new OpenSimplexNoise(MHelper.getSeed((int)534, (int)pos.getX(), (int)pos.getZ()));
        int x1 = pos.getX() - radius - 5;
        int z1 = pos.getZ() - radius - 5;
        int x2 = pos.getX() + radius + 5;
        int z2 = pos.getZ() + radius + 5;
        int y1 = MHelper.floor((double)((double)pos.getY() - (double)(radius + 5) / 1.6));
        int y2 = MHelper.floor((double)((double)pos.getY() + (double)(radius + 5) / 1.6));
        double hr = (double)radius * 0.75;
        double nr = (double)radius * 0.25;
        HashSet brimstone = Sets.newHashSet();
        BlockState rock = EndBlocks.SULPHURIC_ROCK.stone.defaultBlockState();
        int waterLevel = pos.getY() + MHelper.randRange((int)MHelper.floor((double)((double)radius * 0.8)), (int)radius, (RandomSource)random);
        for (int x = x1; x <= x2; ++x) {
            int xsq = x - pos.getX();
            xsq *= xsq;
            mut.setX(x);
            for (int z = z1; z <= z2; ++z) {
                int zsq = z - pos.getZ();
                zsq *= zsq;
                mut.setZ(z);
                for (int y = y1; y <= y2; ++y) {
                    int ysq = y - pos.getY();
                    ysq = (int)((double)ysq * 1.6);
                    ysq *= ysq;
                    mut.setY(y);
                    double r = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * nr + hr;
                    double r2 = r + 5.0;
                    double dist = xsq + ysq + zsq;
                    if (dist < r * r) {
                        state = world.getBlockState((BlockPos)mut);
                        if (!this.isReplaceable(state)) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)(y < waterLevel ? WATER : CAVE_AIR));
                        continue;
                    }
                    if (!(dist < r2 * r2) || !(state = world.getBlockState((BlockPos)mut)).is(CommonBlockTags.END_STONES) && !state.is(Blocks.AIR)) continue;
                    double v = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) + noise.eval((double)x * 0.03, (double)y * 0.03, (double)z * 0.03) * 0.5;
                    if (v > 0.4) {
                        brimstone.add(mut.immutable());
                        continue;
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)rock);
                }
            }
        }
        brimstone.forEach(blockPos -> this.placeBrimstone(world, (BlockPos)blockPos, random));
        if (random.nextInt(4) == 0) {
            int count = MHelper.randRange((int)5, (int)20, (RandomSource)random);
            for (int i = 0; i < count; ++i) {
                mut.set((Vec3i)pos).move(MHelper.floor((double)(random.nextGaussian() * 2.0 + 0.5)), 0, MHelper.floor((double)(random.nextGaussian() * 2.0 + 0.5)));
                int dist = MHelper.floor((double)(3.0f - MHelper.length((float)(mut.getX() - pos.getX()), (float)(mut.getZ() - pos.getZ())))) + random.nextInt(2);
                if (dist <= 0) continue;
                state = world.getBlockState((BlockPos)mut);
                while (!state.getFluidState().isEmpty() || state.is(CommonBlockTags.WATER_PLANT)) {
                    mut.setY(mut.getY() - 1);
                    state = world.getBlockState((BlockPos)mut);
                }
                if (!state.is(CommonBlockTags.END_STONES) || world.getBlockState(mut.above()).is(EndBlocks.HYDROTHERMAL_VENT)) continue;
                for (int j = 0; j <= dist; ++j) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.SULPHURIC_ROCK.stone);
                    MHelper.shuffle((Object[])HORIZONTAL, (RandomSource)random);
                    for (Direction dir : HORIZONTAL) {
                        BlockPos p = mut.relative(dir);
                        if (!random.nextBoolean() || !world.getBlockState(p).is(Blocks.WATER)) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)((BlockState)EndBlocks.TUBE_WORM.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)dir)));
                    }
                    mut.setY(mut.getY() + 1);
                }
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.HYDROTHERMAL_VENT);
                mut.setY(mut.getY() + 1);
                state = world.getBlockState((BlockPos)mut);
                while (state.is(Blocks.WATER)) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)EndBlocks.VENT_BUBBLE_COLUMN.defaultBlockState());
                    world.scheduleTick(mut.immutable(), EndBlocks.VENT_BUBBLE_COLUMN, MHelper.randRange((int)8, (int)32, (RandomSource)random));
                    mut.setY(mut.getY() + 1);
                    state = world.getBlockState((BlockPos)mut);
                }
            }
        }
        BlockFixer.fixBlocks((LevelAccessor)world, new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2));
        return true;
    }

    private boolean isReplaceable(BlockState state) {
        return state.is(CommonBlockTags.END_STONES) || state.is(EndBlocks.HYDROTHERMAL_VENT) || state.is(EndBlocks.VENT_BUBBLE_COLUMN) || state.is(EndBlocks.SULPHUR_CRYSTAL) || BlocksHelper.replaceableOrPlant((BlockState)state) != false || state.is(CommonBlockTags.WATER_PLANT) || state.is(BlockTags.LEAVES);
    }

    private void placeBrimstone(WorldGenLevel world, BlockPos pos, RandomSource random) {
        BlockState state = this.getBrimstone(world, pos);
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
        if (((Boolean)state.getValue((Property)EndBlockProperties.ACTIVE)).booleanValue()) {
            this.makeShards(world, pos, random);
        }
    }

    private BlockState getBrimstone(WorldGenLevel world, BlockPos pos) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (!world.getBlockState(pos.relative(dir)).is(Blocks.WATER)) continue;
            return (BlockState)EndBlocks.BRIMSTONE.defaultBlockState().setValue((Property)EndBlockProperties.ACTIVE, (Comparable)Boolean.valueOf(true));
        }
        return EndBlocks.BRIMSTONE.defaultBlockState();
    }

    private void makeShards(WorldGenLevel world, BlockPos pos, RandomSource random) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            BlockPos side;
            if (random.nextInt(16) != 0 || !world.getBlockState(side = pos.relative(dir)).is(Blocks.WATER)) continue;
            BlockState state = (BlockState)((BlockState)((BlockState)EndBlocks.SULPHUR_CRYSTAL.defaultBlockState().setValue((Property)SulphurCrystalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)SulphurCrystalBlock.FACING, (Comparable)dir)).setValue((Property)SulphurCrystalBlock.AGE, (Comparable)Integer.valueOf(random.nextInt(3)));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)side, (BlockState)state);
        }
    }
}

