/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import com.mojang.math.Axis;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFCoordModify;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFRotation;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.operator.SDFUnion;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFTorus;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.world.features.terrain.ThinArchFeatureConfig;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class ThinArchFeature
extends Feature<ThinArchFeatureConfig> {
    public ThinArchFeature() {
        super(ThinArchFeatureConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<ThinArchFeatureConfig> featurePlaceContext) {
        ThinArchFeatureConfig cfg = (ThinArchFeatureConfig)featurePlaceContext.config();
        WorldGenLevel world = featurePlaceContext.level();
        BlockPos origin = featurePlaceContext.origin();
        RandomSource random = featurePlaceContext.random();
        BlockState state = cfg.block.getState(random, origin);
        Block block = state.getBlock();
        BlockPos pos = DefaultFeature.getPosOnSurfaceWG((WorldGenLevel)world, (BlockPos)new BlockPos(origin.getX() & 0xFFFFFFF0 | 7, 0, origin.getZ() & 0xFFFFFFF0 | 7));
        if (!world.getBlockState(pos.below(5)).is(CommonBlockTags.END_STONES)) {
            return false;
        }
        SDFUnary sdf = null;
        float bigRadius = MHelper.randRange((float)15.0f, (float)20.0f, (RandomSource)random);
        float variation = bigRadius * 0.3f;
        int count = MHelper.randRange((int)2, (int)4, (RandomSource)random);
        for (int i = 0; i < count; ++i) {
            float smallRadius = MHelper.randRange((float)0.6f, (float)1.3f, (RandomSource)random);
            SDFPrimitive arch = new SDFTorus().setBigRadius(bigRadius - random.nextFloat() * variation).setSmallRadius(smallRadius).setBlock(block);
            float angle = ((float)i - (float)count * 0.5f) * 0.3f + random.nextFloat() * 0.05f + 1.5707964f;
            arch = new SDFRotation().setRotation(Axis.XP, angle).setSource((SDF)arch);
            sdf = sdf == null ? arch : new SDFUnion().setSourceA((SDF)sdf).setSourceB((SDF)arch);
        }
        sdf = new SDFRotation().setRotation(MHelper.randomHorizontal((RandomSource)random), random.nextFloat() * ((float)Math.PI * 2)).setSource(sdf);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextLong());
        sdf = new SDFCoordModify().setFunction(vec -> {
            float dx = (float)noise.eval((double)vec.y() * 0.02, (double)vec.z() * 0.02);
            float dy = (float)noise.eval((double)vec.x() * 0.02, (double)vec.z() * 0.02);
            float dz = (float)noise.eval((double)vec.x() * 0.02, (double)vec.y() * 0.02);
            vec.add(dx * 10.0f, dy * 10.0f, dz * 10.0f);
        }).setSource((SDF)sdf);
        sdf = new SDFDisplacement().setFunction(vec -> {
            float offset = vec.y() / bigRadius - 0.5f;
            return Float.valueOf(Mth.clamp((float)(offset * 3.0f), (float)-10.0f, (float)0.0f));
        }).setSource((SDF)sdf);
        float side = (bigRadius + 2.5f) * 2.0f;
        if (side > 47.0f) {
            side = 47.0f;
        }
        sdf.fillArea((ServerLevelAccessor)world, pos, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)pos), (double)side, (double)side, (double)side));
        return true;
    }
}

