/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.PosInfo;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFScale;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.joml.Vector3f;

public class DragonTreeFeature
extends DefaultFeature {
    private static final List<Vector3f> BRANCH = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.3f, 0.0f), new Vector3f(0.4f, 0.6f, 0.0f), new Vector3f(0.8f, 0.8f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)});
    private static final List<Vector3f> SIDE1 = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.4f, 0.6f, 0.0f), new Vector3f(0.8f, 0.8f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)});
    private static final List<Vector3f> SIDE2 = SplineHelper.copySpline(SIDE1);
    private static final List<Vector3f> ROOT;

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        if (!world.getBlockState(pos.below()).is(BlockTags.NYLIUM)) {
            return false;
        }
        float size = MHelper.randRange((int)10, (int)25, (RandomSource)random);
        List spline = SplineHelper.makeSpline((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)size, (float)0.0f, (int)6);
        SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)1.0f, (float)0.0f, (float)1.0f);
        if (!SplineHelper.canGenerate((List)spline, (BlockPos)pos, (WorldGenLevel)world, DragonTreeFeature.replaceFunc())) {
            return false;
        }
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)AIR);
        Vector3f last = SplineHelper.getPos((List)spline, (float)3.5f);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextLong());
        float radius = size * MHelper.randRange((float)0.5f, (float)0.7f, (RandomSource)random);
        this.makeCap(world, pos.offset((int)last.x(), (int)last.y(), (int)last.z()), radius, random, noise);
        last = (Vector3f)spline.get(0);
        this.makeRoots(world, pos.offset((int)last.x(), (int)last.y(), (int)last.z()), radius, random);
        radius = MHelper.randRange((float)1.2f, (float)2.3f, (RandomSource)random);
        SDF function = SplineHelper.buildSDF((List)spline, (float)radius, (float)1.2f, bpos -> EndBlocks.DRAGON_TREE.getBark().defaultBlockState());
        function.setReplaceFunction(DragonTreeFeature.replaceFunc());
        function.addPostProcess(DragonTreeFeature.postProcessFunc());
        function.fillRecursiveIgnore((ServerLevelAccessor)world, pos, DragonTreeFeature.ignoreFunc());
        return true;
    }

    private void makeCap(WorldGenLevel world, BlockPos pos, float radius, RandomSource random, OpenSimplexNoise noise) {
        int count = (int)radius;
        int offset = (int)(BRANCH.get(BRANCH.size() - 1).y() * radius);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * MHelper.randRange((float)0.85f, (float)1.15f, (RandomSource)random);
            List branch = SplineHelper.copySpline(BRANCH);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            SplineHelper.fillSpline((List)branch, (WorldGenLevel)world, (BlockState)EndBlocks.DRAGON_TREE.getBark().defaultBlockState(), (BlockPos)pos, DragonTreeFeature.replaceFunc());
            branch = SplineHelper.copySpline(SIDE1);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            SplineHelper.fillSpline((List)branch, (WorldGenLevel)world, (BlockState)EndBlocks.DRAGON_TREE.getBark().defaultBlockState(), (BlockPos)pos, DragonTreeFeature.replaceFunc());
            branch = SplineHelper.copySpline(SIDE2);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            SplineHelper.fillSpline((List)branch, (WorldGenLevel)world, (BlockState)EndBlocks.DRAGON_TREE.getBark().defaultBlockState(), (BlockPos)pos, DragonTreeFeature.replaceFunc());
        }
        this.leavesBall(world, pos.above(offset), radius * 1.15f + 2.0f, random, noise);
    }

    private void makeRoots(WorldGenLevel world, BlockPos pos, float radius, RandomSource random) {
        int count = (int)(radius * 1.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * MHelper.randRange((float)0.85f, (float)1.15f, (RandomSource)random);
            List branch = SplineHelper.copySpline(ROOT);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            Vector3f last = (Vector3f)branch.get(branch.size() - 1);
            if (!world.getBlockState(pos.offset((int)last.x(), (int)last.y(), (int)last.z())).is(CommonBlockTags.END_STONES)) continue;
            SplineHelper.fillSpline((List)branch, (WorldGenLevel)world, (BlockState)EndBlocks.DRAGON_TREE.getBark().defaultBlockState(), (BlockPos)pos, DragonTreeFeature.replaceFunc());
        }
    }

    private void leavesBall(WorldGenLevel world, BlockPos pos, float radius, RandomSource random, OpenSimplexNoise noise) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock((BlockState)EndBlocks.DRAGON_TREE_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(6)));
        SDFUnary sub = new SDFScale().setScale(5.0f).setSource((SDF)sphere);
        sub = new SDFTranslate().setTranslate(0.0f, -radius * 5.0f, 0.0f).setSource((SDF)sub);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 1.5f)).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(random.nextFloat() * 3.0f - 1.5f)).setSource((SDF)sphere);
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        sphere.addPostProcess(info -> {
            if (random.nextInt(5) == 0) {
                for (Direction dir : Direction.values()) {
                    BlockState state = info.getState(dir, 2);
                    if (!state.isAir()) continue;
                    return info.getState();
                }
                info.setState(EndBlocks.DRAGON_TREE.getBark().defaultBlockState());
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.setX(x + info.getPos().getX());
                    for (int z = -6; z < 7; ++z) {
                        int az = Math.abs(z);
                        mut.setZ(z + info.getPos().getZ());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + az;
                            if (d >= 7) continue;
                            mut.setY(y + info.getPos().getY());
                            BlockState state = info.getState((BlockPos)mut);
                            if (!(state.getBlock() instanceof LeavesBlock) || d >= (distance = ((Integer)state.getValue((Property)LeavesBlock.DISTANCE)).intValue())) continue;
                            info.setState((BlockPos)mut, (BlockState)state.setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((ServerLevelAccessor)world, pos, DragonTreeFeature.ignoreFunc());
        if (radius > 5.0f) {
            int count = (int)(radius * 2.5f);
            for (int i = 0; i < count; ++i) {
                BlockPos p = pos.offset((int)(random.nextGaussian() * 1.0), (int)(random.nextGaussian() * 1.0), (int)(random.nextGaussian() * 1.0));
                boolean place = true;
                for (Direction d : Direction.values()) {
                    BlockState state = world.getBlockState(p.relative(d));
                    if (EndBlocks.DRAGON_TREE.isTreeLog(state) || state.is(EndBlocks.DRAGON_TREE_LEAVES)) continue;
                    place = false;
                    break;
                }
                if (!place) continue;
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (Block)EndBlocks.DRAGON_TREE.getBark());
            }
        }
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (Block)EndBlocks.DRAGON_TREE.getBark());
    }

    private static Function<BlockState, Boolean> replaceFunc() {
        return state -> {
            if (state.getBlock() == EndBlocks.DRAGON_TREE_LEAVES) {
                return true;
            }
            return BlocksHelper.replaceableOrPlant((BlockState)state);
        };
    }

    private static Function<BlockState, Boolean> ignoreFunc() {
        return EndBlocks.DRAGON_TREE::isTreeLog;
    }

    private static Function<PosInfo, BlockState> postProcessFunc() {
        return info -> {
            if (EndBlocks.DRAGON_TREE.isTreeLog(info.getStateUp()) && EndBlocks.DRAGON_TREE.isTreeLog(info.getStateDown())) {
                return EndBlocks.DRAGON_TREE.getLog().defaultBlockState();
            }
            return info.getState();
        };
    }

    static {
        Vector3f offset1 = new Vector3f(-0.4f, -0.6f, 0.0f);
        Vector3f offset2 = new Vector3f(0.4f, 0.6f, 0.0f);
        SplineHelper.offset(SIDE1, (Vector3f)offset1);
        SplineHelper.offset(SIDE2, (Vector3f)offset1);
        SplineHelper.rotateSpline(SIDE1, (float)0.5f);
        SplineHelper.rotateSpline(SIDE2, (float)-0.5f);
        SplineHelper.offset(SIDE1, (Vector3f)offset2);
        SplineHelper.offset(SIDE2, (Vector3f)offset2);
        ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});
        SplineHelper.offset(ROOT, (Vector3f)new Vector3f(0.0f, -0.45f, 0.0f));
    }
}

