/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFFlatWave;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSmoothUnion;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.blocks.JellyshroomCapBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.joml.Vector3f;

public class JellyshroomFeature
extends DefaultFeature {
    private static final Function<BlockState, Boolean> REPLACE;
    private static final List<Vector3f> ROOT;

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        if (!world.getBlockState(pos.below()).is(BlockTags.NYLIUM)) {
            return false;
        }
        BlockState bark = EndBlocks.JELLYSHROOM.getBark().defaultBlockState();
        BlockState membrane = EndBlocks.JELLYSHROOM_CAP_PURPLE.defaultBlockState();
        int height = MHelper.randRange((int)5, (int)8, (RandomSource)random);
        float radius = (float)height * MHelper.randRange((float)0.15f, (float)0.25f, (RandomSource)random);
        List spline = SplineHelper.makeSpline((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)height, (float)0.0f, (int)3);
        SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)0.5f, (float)0.0f, (float)0.5f);
        SDF sdf = SplineHelper.buildSDF((List)spline, (float)radius, (float)0.8f, bpos -> bark);
        radius = (float)height * MHelper.randRange((float)0.7f, (float)0.9f, (RandomSource)random);
        if (radius < 1.5f) {
            radius = 1.5f;
        }
        float membraneRadius = radius;
        SDF cap = this.makeCap(membraneRadius, random, membrane);
        Vector3f last = (Vector3f)spline.get(spline.size() - 1);
        cap = new SDFTranslate().setTranslate(last.x(), last.y(), last.z()).setSource(cap);
        sdf = new SDFSmoothUnion().setRadius(3.0f).setSourceA(sdf).setSourceB(cap);
        sdf.setReplaceFunction(REPLACE).addPostProcess(info -> {
            if (EndBlocks.JELLYSHROOM.isTreeLog(info.getState())) {
                if (EndBlocks.JELLYSHROOM.isTreeLog(info.getStateUp()) && EndBlocks.JELLYSHROOM.isTreeLog(info.getStateDown())) {
                    return EndBlocks.JELLYSHROOM.getLog().defaultBlockState();
                }
            } else if (info.getState().is(EndBlocks.JELLYSHROOM_CAP_PURPLE)) {
                float dx = (float)(info.getPos().getX() - pos.getX()) - last.x();
                float dz = (float)(info.getPos().getZ() - pos.getZ()) - last.z();
                float distance = MHelper.length((float)dx, (float)dz) / membraneRadius * 7.0f;
                int color = Mth.clamp((int)MHelper.floor((double)distance), (int)0, (int)7);
                return (BlockState)info.getState().setValue((Property)JellyshroomCapBlock.COLOR, (Comparable)Integer.valueOf(color));
            }
            return info.getState();
        }).fillRecursive((ServerLevelAccessor)world, pos);
        radius = (float)height * 0.5f;
        this.makeRoots(world, pos.offset(0, 2, 0), radius, random, bark);
        return true;
    }

    private void makeRoots(WorldGenLevel world, BlockPos pos, float radius, RandomSource random, BlockState wood) {
        int count = (int)(radius * 3.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * MHelper.randRange((float)0.85f, (float)1.15f, (RandomSource)random);
            List branch = SplineHelper.copySpline(ROOT);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            Vector3f last = (Vector3f)branch.get(branch.size() - 1);
            if (!world.getBlockState(pos.offset((int)last.x(), (int)last.y(), (int)last.z())).is(CommonBlockTags.END_STONES)) continue;
            SplineHelper.fillSpline((List)branch, (WorldGenLevel)world, (BlockState)wood, (BlockPos)pos, REPLACE);
        }
    }

    private SDF makeCap(float radius, RandomSource random, BlockState cap) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock(cap);
        SDFUnary sub = new SDFTranslate().setTranslate(0.0f, -4.0f, 0.0f).setSource((SDF)sphere);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFTranslate().setTranslate(0.0f, 1.0f - radius * 0.5f, 0.0f).setSource((SDF)sphere);
        float angle = random.nextFloat() * ((float)Math.PI * 2);
        int count = (int)MHelper.randRange((float)(radius * 0.5f), (float)radius, (RandomSource)random);
        if (count < 3) {
            count = 3;
        }
        sphere = new SDFFlatWave().setAngle(angle).setRaysCount(count).setIntensity(0.2f).setSource((SDF)sphere);
        return sphere;
    }

    static {
        ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});
        SplineHelper.offset(ROOT, (Vector3f)new Vector3f(0.0f, -0.45f, 0.0f));
        REPLACE = BlocksHelper::replaceableOrPlant;
    }
}

