/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.features;

import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.betterx.bclib.api.v2.levelgen.structures.StructureWorld;
import org.betterx.bclib.sdf.PosInfo;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFRotation;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnion;
import org.betterx.bclib.sdf.primitive.SDFCappedCone;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.world.structures.features.SDFStructureFeature;
import org.betterx.betterend.world.structures.piece.VoxelPiece;
import org.joml.Vector3f;

public class GiantIceStarStructure
extends SDFStructureFeature {
    private static final float minSize = 20.0f;
    private static final float maxSize = 35.0f;
    private static final int minCount = 25;
    private static final int maxCount = 40;

    public GiantIceStarStructure(Structure.StructureSettings s) {
        super(s);
    }

    public StructureType<GiantIceStarStructure> type() {
        return EndStructures.GIANT_ICE_STAR.type();
    }

    protected static SDF getSDF(BlockPos pos, RandomSource random) {
        float size = MHelper.randRange((float)20.0f, (float)35.0f, (RandomSource)random);
        int count = MHelper.randRange((int)25, (int)40, (RandomSource)random);
        List<Vector3f> points = GiantIceStarStructure.getFibonacciPoints(count);
        SDFPrimitive sdf = null;
        SDFPrimitive spike = new SDFCappedCone().setRadius1(3.0f + (size - 5.0f) * 0.2f).setRadius2(0.0f).setHeight(size).setBlock(EndBlocks.DENSE_SNOW);
        spike = new SDFTranslate().setTranslate(0.0f, size - 0.5f, 0.0f).setSource((SDF)spike);
        for (Vector3f point : points) {
            SDFPrimitive rotated = spike;
            float angle = MHelper.angle((Vector3f)MHelper.YP, (Vector3f)(point = MHelper.normalize((Vector3f)point)));
            if (angle > 0.01f && angle < 3.14f) {
                Vector3f axis = MHelper.normalize((Vector3f)MHelper.cross((Vector3f)MHelper.YP, (Vector3f)point));
                rotated = new SDFRotation().setRotation(axis, angle).setSource((SDF)spike);
            } else if (angle > 1.0f) {
                rotated = new SDFRotation().setRotation(Axis.YP, (float)Math.PI).setSource((SDF)spike);
            }
            sdf = sdf == null ? rotated : new SDFUnion().setSourceA((SDF)sdf).setSourceB((SDF)rotated);
        }
        float ancientRadius = size * 0.7f;
        float denseRadius = size * 0.9f;
        float iceRadius = size < 7.0f ? size * 5.0f : size * 1.3f;
        float randScale = size * 0.3f;
        BlockPos center = pos;
        BlockState ice = EndBlocks.EMERALD_ICE.defaultBlockState();
        BlockState dense = EndBlocks.DENSE_EMERALD_ICE.defaultBlockState();
        BlockState ancient = EndBlocks.ANCIENT_EMERALD_ICE.defaultBlockState();
        SDFPrimitive sdfCopy = sdf;
        return sdf.addPostProcess(arg_0 -> GiantIceStarStructure.lambda$getSDF$0(center, (SDF)sdfCopy, random, randScale, ancientRadius, ancient, denseRadius, dense, iceRadius, ice, arg_0));
    }

    private static List<Vector3f> getFibonacciPoints(int count) {
        float max = count - 1;
        ArrayList<Vector3f> result = new ArrayList<Vector3f>(count);
        for (int i = 0; i < count; ++i) {
            float y = 1.0f - (float)i / max * 2.0f;
            float radius = (float)Math.sqrt(1.0f - y * y);
            float theta = MHelper.PHI * (float)i;
            float x = (float)Math.cos(theta) * radius;
            float z = (float)Math.sin(theta) * radius;
            result.add(new Vector3f(x, y, z));
        }
        return result;
    }

    @Override
    public void generatePieces(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context) {
        WorldgenRandom random = context.random();
        ChunkPos chunkPos = context.chunkPos();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        LevelHeightAccessor levelHeightAccessor = context.heightAccessor();
        int x = chunkPos.getBlockX(MHelper.randRange((int)4, (int)12, (RandomSource)random));
        int z = chunkPos.getBlockZ(MHelper.randRange((int)4, (int)12, (RandomSource)random));
        BlockPos start = new BlockPos(x, MHelper.randRange((int)32, (int)128, (RandomSource)random), z);
        VoxelPiece piece = new VoxelPiece(arg_0 -> GiantIceStarStructure.lambda$generatePieces$1(start, (RandomSource)random, arg_0), random.nextInt());
        structurePiecesBuilder.addPiece((StructurePiece)piece);
    }

    private static /* synthetic */ void lambda$generatePieces$1(BlockPos start, RandomSource random, StructureWorld world) {
        GiantIceStarStructure.getSDF(start, random).fillRecursive(world, start);
    }

    private static /* synthetic */ BlockState lambda$getSDF$0(BlockPos center, SDF sdfCopy, RandomSource random, float randScale, float ancientRadius, BlockState ancient, float denseRadius, BlockState dense, float iceRadius, BlockState ice, PosInfo info) {
        float pz;
        float py;
        BlockPos bpos = info.getPos();
        float px = bpos.getX() - center.getX();
        float distance = MHelper.length((float)px, (float)(py = (float)(bpos.getY() - center.getY())), (float)(pz = (float)(bpos.getZ() - center.getZ()))) + sdfCopy.getDistance(px, py, pz) * 0.4f + random.nextFloat() * randScale;
        if (distance < ancientRadius) {
            return ancient;
        }
        if (distance < denseRadius) {
            return dense;
        }
        if (distance < iceRadius) {
            return ice;
        }
        return info.getState();
    }
}

