/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.piece;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.util.GlobalState;
import org.betterx.betterend.world.structures.piece.BasePiece;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class CavePiece
extends BasePiece {
    private OpenSimplexNoise noise;
    private BlockPos center;
    private float radius;

    public CavePiece(BlockPos center, float radius, int id) {
        super(EndStructures.CAVE_PIECE, id, null);
        this.center = center;
        this.radius = radius;
        this.noise = new OpenSimplexNoise(MHelper.getSeed((int)534, (int)center.getX(), (int)center.getZ()));
        this.makeBoundingBox();
    }

    public CavePiece(StructurePieceSerializationContext type, CompoundTag tag) {
        super(EndStructures.CAVE_PIECE, tag);
        this.makeBoundingBox();
    }

    public void postProcess(WorldGenLevel world, StructureManager arg, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        int x1 = MHelper.max((int)this.boundingBox.minX(), (int)blockBox.minX());
        int z1 = MHelper.max((int)this.boundingBox.minZ(), (int)blockBox.minZ());
        int x2 = MHelper.min((int)this.boundingBox.maxX(), (int)blockBox.maxX());
        int z2 = MHelper.min((int)this.boundingBox.maxZ(), (int)blockBox.maxZ());
        int y1 = this.boundingBox.minY();
        int y2 = this.boundingBox.maxY();
        double hr = (double)this.radius * 0.75;
        double nr = (double)this.radius * 0.25;
        BlockPos.MutableBlockPos pos = GlobalState.stateForThread().POS;
        for (int x = x1; x <= x2; ++x) {
            int xsq = x - this.center.getX();
            xsq *= xsq;
            pos.setX(x);
            for (int z = z1; z <= z2; ++z) {
                int zsq = z - this.center.getZ();
                zsq *= zsq;
                pos.setZ(z);
                for (int y = y1; y <= y2; ++y) {
                    int ysq = y - this.center.getY();
                    ysq = (int)((double)ysq * 1.6);
                    ysq *= ysq;
                    pos.setY(y);
                    double r = this.noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * nr + hr;
                    double r2 = r - 4.5;
                    double dist = xsq + ysq + zsq;
                    if (dist < r2 * r2) {
                        if (!world.getBlockState((BlockPos)pos).is(CommonBlockTags.END_STONES)) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)CAVE_AIR);
                        continue;
                    }
                    if (!(dist < r * r) || !world.getBlockState((BlockPos)pos).canBeReplaced()) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (Block)Blocks.END_STONE);
                }
            }
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.put("center", NbtUtils.writeBlockPos((BlockPos)this.center));
        tag.putFloat("radius", this.radius);
    }

    @Override
    protected void fromNbt(CompoundTag tag) {
        this.center = NbtUtils.readBlockPos((CompoundTag)tag, (String)"center").orElse(BlockPos.ZERO);
        this.radius = tag.getFloat("radius");
        this.noise = new OpenSimplexNoise(MHelper.getSeed((int)534, (int)this.center.getX(), (int)this.center.getZ()));
    }

    private void makeBoundingBox() {
        int minX = MHelper.floor((double)((float)this.center.getX() - this.radius));
        int minY = MHelper.floor((double)((float)this.center.getY() - this.radius));
        int minZ = MHelper.floor((double)((float)this.center.getZ() - this.radius));
        int maxX = MHelper.floor((double)((float)this.center.getX() + this.radius + 1.0f));
        int maxY = MHelper.floor((double)((float)this.center.getY() + this.radius + 1.0f));
        int maxZ = MHelper.floor((double)((float)this.center.getZ() + this.radius + 1.0f));
        this.boundingBox = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

