/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.betterend.worldgen;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.util.JsonFactory;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.registry.EndTags;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.EndBiomeBuilder;
import org.betterx.betterend.world.biome.EndBiomeKey;
import org.betterx.betterend.world.biome.air.BiomeIceStarfield;
import org.betterx.betterend.world.biome.cave.EmptyAuroraCaveBiome;
import org.betterx.betterend.world.biome.cave.EmptyEndCaveBiome;
import org.betterx.betterend.world.biome.cave.EmptySmaragdantCaveBiome;
import org.betterx.betterend.world.biome.cave.JadeCaveBiome;
import org.betterx.betterend.world.biome.cave.LushAuroraCaveBiome;
import org.betterx.betterend.world.biome.cave.LushSmaragdantCaveBiome;
import org.betterx.betterend.world.biome.land.AmberLandBiome;
import org.betterx.betterend.world.biome.land.BlossomingSpiresBiome;
import org.betterx.betterend.world.biome.land.ChorusForestBiome;
import org.betterx.betterend.world.biome.land.CrystalMountainsBiome;
import org.betterx.betterend.world.biome.land.DragonGraveyardsBiome;
import org.betterx.betterend.world.biome.land.DryShrublandBiome;
import org.betterx.betterend.world.biome.land.DustWastelandsBiome;
import org.betterx.betterend.world.biome.land.FoggyMushroomlandBiome;
import org.betterx.betterend.world.biome.land.GlowingGrasslandsBiome;
import org.betterx.betterend.world.biome.land.LanternWoodsBiome;
import org.betterx.betterend.world.biome.land.MegalakeBiome;
import org.betterx.betterend.world.biome.land.MegalakeGroveBiome;
import org.betterx.betterend.world.biome.land.NeonOasisBiome;
import org.betterx.betterend.world.biome.land.PaintedMountainsBiome;
import org.betterx.betterend.world.biome.land.ShadowForestBiome;
import org.betterx.betterend.world.biome.land.SulphurSpringsBiome;
import org.betterx.betterend.world.biome.land.UmbraValleyBiome;
import org.betterx.betterend.world.biome.land.UmbrellaJungleBiome;
import org.betterx.betterend.world.features.BuildingListFeature;
import org.betterx.betterend.world.features.BuildingListFeatureConfig;
import org.betterx.betterend.world.features.NBTFeature;
import org.betterx.wover.biome.api.builder.BiomeBootstrapContext;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.provider.multi.WoverBiomeProvider;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureManager;
import org.betterx.wover.feature.api.configured.configurators.WithConfiguration;
import org.betterx.wover.feature.api.placed.BasePlacedFeatureKey;
import org.betterx.wover.feature.api.placed.PlacedConfiguredFeatureKey;
import org.betterx.wover.feature.api.placed.PlacedFeatureManager;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.tag.api.predefined.CommonBiomeTags;
import org.jetbrains.annotations.NotNull;

public class EndBiomesProvider
extends WoverBiomeProvider {
    public static final Map<EndBiomeKey<?, ?>, BiomeInfo> BIOMES = new HashMap();

    public EndBiomesProvider(@NotNull ModCore modCore) {
        super(modCore);
    }

    public static void loadAllBiomeConfigs() {
        EndBiomesProvider.putBiome(EndBiomes.FOGGY_MUSHROOMLAND, new FoggyMushroomlandBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.CHORUS_FOREST, new ChorusForestBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_HIGHLAND);
        EndBiomesProvider.putBiome(EndBiomes.DUST_WASTELANDS, new DustWastelandsBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_MIDLAND);
        EndBiomesProvider.putBiome(EndBiomes.NEON_OASIS, new NeonOasisBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.PAINTED_MOUNTAINS, new PaintedMountainsBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.MEGALAKE, new MegalakeBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.MEGALAKE_GROVE, new MegalakeGroveBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.CRYSTAL_MOUNTAINS, new CrystalMountainsBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.SHADOW_FOREST, new ShadowForestBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.AMBER_LAND, new AmberLandBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.BLOSSOMING_SPIRES, new BlossomingSpiresBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.SULPHUR_SPRINGS, new SulphurSpringsBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.UMBRELLA_JUNGLE, new UmbrellaJungleBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.GLOWING_GRASSLANDS, new GlowingGrasslandsBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.DRAGON_GRAVEYARDS, new DragonGraveyardsBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.DRY_SHRUBLAND, new DryShrublandBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.LANTERN_WOODS, new LanternWoodsBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.UMBRA_VALLEY, new UmbraValleyBiome(), (TagKey<Biome>)CommonBiomeTags.IS_END_LAND);
        EndBiomesProvider.putBiome(EndBiomes.ICE_STARFIELD, new BiomeIceStarfield(), (TagKey<Biome>)CommonBiomeTags.IS_SMALL_END_ISLAND);
        EndBiomesProvider.putBiome(EndBiomes.EMPTY_END_CAVE, new EmptyEndCaveBiome(EndBiomes.EMPTY_END_CAVE), EndTags.IS_END_CAVE);
        EndBiomesProvider.putBiome(EndBiomes.EMPTY_SMARAGDANT_CAVE, new EmptySmaragdantCaveBiome(EndBiomes.EMPTY_SMARAGDANT_CAVE), EndTags.IS_END_CAVE);
        EndBiomesProvider.putBiome(EndBiomes.LUSH_SMARAGDANT_CAVE, new LushSmaragdantCaveBiome(EndBiomes.LUSH_SMARAGDANT_CAVE), EndTags.IS_END_CAVE);
        EndBiomesProvider.putBiome(EndBiomes.EMPTY_AURORA_CAVE, new EmptyAuroraCaveBiome(EndBiomes.EMPTY_AURORA_CAVE), EndTags.IS_END_CAVE);
        EndBiomesProvider.putBiome(EndBiomes.LUSH_AURORA_CAVE, new LushAuroraCaveBiome(EndBiomes.LUSH_AURORA_CAVE), EndTags.IS_END_CAVE);
        EndBiomesProvider.putBiome(EndBiomes.JADE_CAVE, new JadeCaveBiome(EndBiomes.JADE_CAVE), EndTags.IS_END_CAVE);
    }

    private static void putBiome(EndBiomeKey<?, ?> key, EndBiome.Config config, TagKey<Biome> tag) {
        List<BuildingListFeature.StructureInfo> structures = EndBiomesProvider.getBiomeStructures(key.key.location());
        PlacedConfiguredFeatureKey placed = null;
        ConfiguredFeatureKey configuredFeatureKey = null;
        if (structures != null) {
            configuredFeatureKey = ConfiguredFeatureManager.configuration((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)key.key.location().getNamespace(), (String)(key.key.location().getPath() + "_structures")), (Feature)EndFeatures.BUILDING_LIST_FEATURE);
            placed = (PlacedConfiguredFeatureKey)PlacedFeatureManager.createKey((ConfiguredFeatureKey)configuredFeatureKey).setDecoration(GenerationStep.Decoration.SURFACE_STRUCTURES);
        }
        BIOMES.put(key, new BiomeInfo(config, tag, structures, configuredFeatureKey, placed));
    }

    protected void bootstrap(BiomeBootstrapContext context) {
        for (Map.Entry<EndBiomeKey<?, ?>, BiomeInfo> e : BIOMES.entrySet()) {
            EndBiomeBuilder builder = e.getKey().bootstrap(context, e.getValue().config, e.getValue().tag);
            if (e.getValue().placed != null) {
                builder.feature((BasePlacedFeatureKey)e.getValue().placed);
            }
            builder.register();
        }
    }

    private static List<BuildingListFeature.StructureInfo> getBiomeStructures(ResourceLocation loc) {
        String ns = loc.getNamespace();
        String nm = loc.getPath();
        return EndBiomesProvider.getBiomeStructures(ns, nm);
    }

    private static List<BuildingListFeature.StructureInfo> getBiomeStructures(String ns, String nm) {
        JsonObject obj;
        JsonArray structures;
        String path;
        InputStream inputstream;
        Registry features;
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)ns, (String)(nm + "_structures"));
        if (WorldState.allStageRegistryAccess() != null && (features = WorldState.allStageRegistryAccess().registryOrThrow(Registries.PLACED_FEATURE)).containsKey(id)) {
            BCLib.LOGGER.info("Feature for " + String.valueOf(id) + " was already build");
        }
        if ((inputstream = EndFeatures.class.getResourceAsStream((path = "/data/" + ns + "/structure/biome/" + nm + "/") + "structures.json")) != null && (structures = (obj = JsonFactory.getJsonObject((InputStream)inputstream)).getAsJsonArray("structures")) != null) {
            ArrayList list = Lists.newArrayList();
            structures.forEach(entry -> {
                JsonObject e = entry.getAsJsonObject();
                String structure = path + e.get("nbt").getAsString() + ".nbt";
                NBTFeature.TerrainMerge terrainMerge = NBTFeature.TerrainMerge.getFromString(e.get("terrainMerge").getAsString());
                int offsetY = e.get("offsetY").getAsInt();
                list.add(new BuildingListFeature.StructureInfo(structure, offsetY, terrainMerge));
            });
            if (!list.isEmpty()) {
                return list;
            }
        }
        return null;
    }

    public record BiomeInfo(EndBiome.Config config, TagKey<Biome> tag, List<BuildingListFeature.StructureInfo> structures, ConfiguredFeatureKey<WithConfiguration<BuildingListFeature, BuildingListFeatureConfig>> configuredFeatureKey, PlacedConfiguredFeatureKey placed) {
    }
}

