/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.layout.components.AbstractVanillaComponentRenderer;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;

public abstract class AbstractVanillaComponent<C extends AbstractWidget, V extends AbstractVanillaComponent<C, V>>
extends LayoutComponent<AbstractVanillaComponentRenderer<C, V>, V> {
    protected C vanillaComponent;
    protected final Component component;
    protected float alpha = 1.0f;
    protected boolean enabled = true;

    public AbstractVanillaComponent(Value width, Value height, AbstractVanillaComponentRenderer<C, V> renderer, Component component) {
        super(width, height, renderer);
        this.component = component;
        renderer.linkedComponent = this;
    }

    protected abstract C createVanillaComponent();

    @Override
    protected void onBoundsChanged() {
        this.vanillaComponent = this.createVanillaComponent();
        this.vanillaComponent.setAlpha(this.alpha);
    }

    protected Component contentComponent() {
        return this.component;
    }

    @Override
    public int getContentWidth() {
        return ((AbstractVanillaComponentRenderer)this.renderer).getWidth(this.contentComponent());
    }

    @Override
    public int getContentHeight() {
        return ((AbstractVanillaComponentRenderer)this.renderer).getHeight(this.contentComponent());
    }

    public float getAlpha() {
        return this.alpha;
    }

    public V setAlpha(float alpha) {
        this.alpha = alpha;
        if (this.vanillaComponent != null) {
            this.vanillaComponent.setAlpha(alpha);
        }
        return (V)this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public V setEnabled(boolean enabled) {
        this.enabled = enabled;
        return (V)this;
    }

    public void mouseMoved(double x, double y) {
        if (this.vanillaComponent != null && this.enabled) {
            this.vanillaComponent.mouseMoved(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top);
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.vanillaComponent != null && this.enabled) {
            return this.vanillaComponent.mouseClicked(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top, button);
        }
        return false;
    }

    public boolean mouseReleased(double x, double y, int button) {
        if (this.vanillaComponent != null && this.enabled) {
            return this.vanillaComponent.mouseReleased(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top, button);
        }
        return false;
    }

    public boolean mouseDragged(double x, double y, int button, double x2, double y2) {
        if (this.vanillaComponent != null && this.enabled) {
            return this.vanillaComponent.mouseDragged(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top, button, x2 - (double)this.relativeBounds.left, y2 - (double)this.relativeBounds.top);
        }
        return false;
    }

    public boolean mouseScrolled(double x, double y, double f, double g) {
        if (this.vanillaComponent != null && this.enabled) {
            return this.vanillaComponent.mouseScrolled(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top, f, g);
        }
        return false;
    }

    public boolean keyPressed(int i, int j, int k) {
        if (this.vanillaComponent != null && this.enabled) {
            return this.vanillaComponent.keyPressed(i, j, k);
        }
        return false;
    }

    public boolean keyReleased(int i, int j, int k) {
        if (this.vanillaComponent != null && this.enabled) {
            return this.vanillaComponent.keyReleased(i, j, k);
        }
        return false;
    }

    public boolean charTyped(char c, int i) {
        if (this.vanillaComponent != null && this.enabled) {
            return this.vanillaComponent.charTyped(c, i);
        }
        return false;
    }

    public boolean isFocused() {
        if (this.vanillaComponent != null) {
            return this.vanillaComponent.isFocused();
        }
        return false;
    }

    public void setFocused(boolean bl) {
        if (this.vanillaComponent != null) {
            this.vanillaComponent.setFocused(bl);
        }
    }

    @Override
    public boolean isMouseOver(double x, double y) {
        if (this.vanillaComponent != null && this.enabled) {
            return this.vanillaComponent.isMouseOver(x - (double)this.relativeBounds.left, y - (double)this.relativeBounds.top);
        }
        return false;
    }
}

