/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.layout.components.AbstractVanillaComponent;
import de.ambertation.wunderlib.ui.layout.components.render.RangeRenderer;
import de.ambertation.wunderlib.ui.layout.values.Value;
import de.ambertation.wunderlib.ui.vanilla.Slider;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Range<N extends Number>
extends AbstractVanillaComponent<Slider<N>, Range<N>> {
    private ValueChanged<N> onChange = (a, b) -> {};
    private final N minValue;
    private final N maxValue;
    private final N initialValue;
    private boolean focused;

    public Range(Value width, Value height, Component component, N minValue, N maxValue, N initialValue) {
        super(width, height, new RangeRenderer(), component);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.initialValue = initialValue;
    }

    public Range(Value width, Value height, N minValue, N maxValue, N initialValue) {
        this(width, height, null, minValue, maxValue, initialValue);
    }

    public Range<N> onChange(ValueChanged<N> onChange) {
        this.onChange = onChange;
        return this;
    }

    @Override
    protected Slider<N> createVanillaComponent() {
        Range self = this;
        return new Slider<Number>(0, 0, this.relativeBounds.width, this.relativeBounds.height, this.component, (Number)this.minValue, (Number)this.maxValue, (Number)this.getValue(), (s, v) -> this.onChange.now(self, v));
    }

    public N getValue() {
        if (this.vanillaComponent != null) {
            return ((Slider)this.vanillaComponent).currentValue();
        }
        return this.initialValue;
    }

    @Override
    protected Component contentComponent() {
        Slider<Number> dummy = new Slider<Number>(0, 0, 100, 20, this.component, (Number)this.minValue, (Number)this.maxValue, (Number)this.initialValue, (a, b) -> {});
        return dummy.getValueComponent((Number)this.maxValue);
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(boolean bl) {
        this.focused = bl;
    }

    @FunctionalInterface
    public static interface ValueChanged<N extends Number> {
        public void now(Range<N> var1, N var2);
    }
}

