/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.impl.modification;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.wover.biome.api.modification.BiomeModification;
import org.betterx.wover.biome.api.modification.predicates.BiomePredicate;
import org.betterx.wover.biome.impl.modification.FeatureMap;
import org.betterx.wover.biome.impl.modification.GenerationSettingsWorker;
import org.betterx.wover.biome.impl.modification.MobSettingsWorker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiomeModificationImpl
implements BiomeModification {
    @NotNull
    private final BiomePredicate predicate;
    @NotNull
    private final FeatureMap features;
    @Nullable
    private final List<TagKey<Biome>> biomeTags;
    @NotNull
    private final List<MobSpawnSettings.SpawnerData> spawns;

    public BiomeModificationImpl(@NotNull BiomePredicate predicate, @NotNull List<List<Holder<PlacedFeature>>> features, @Nullable List<TagKey<Biome>> biomeTags, @Nullable List<MobSpawnSettings.SpawnerData> spawns) {
        this(predicate, FeatureMap.of(features), biomeTags, spawns);
    }

    public BiomeModificationImpl(@NotNull BiomePredicate predicate, @NotNull FeatureMap features, @Nullable List<TagKey<Biome>> biomeTags, @Nullable List<MobSpawnSettings.SpawnerData> spawns) {
        this.predicate = predicate;
        this.features = features;
        this.biomeTags = biomeTags;
        this.spawns = spawns;
    }

    @Override
    public BiomePredicate predicate() {
        return this.predicate;
    }

    @Override
    public List<TagKey<Biome>> biomeTags() {
        return this.biomeTags;
    }

    @Override
    public final List<List<Holder<PlacedFeature>>> features() {
        return this.features.generic();
    }

    @Override
    public List<List<ResourceKey<PlacedFeature>>> featureKeys() {
        return this.features.keys();
    }

    @Override
    public List<MobSpawnSettings.SpawnerData> spawns() {
        return this.spawns;
    }

    @Override
    public void apply(GenerationSettingsWorker worker, MobSettingsWorker mobWorker) {
        worker.addFeatures(this.features);
        mobWorker.addSpawns(this.spawns);
    }
}

