/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.impl.modification;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.betterx.wover.biome.api.modification.predicates.BiomePredicate;
import org.betterx.wover.biome.mixin.HolderSetNamedAccessor;
import org.betterx.wover.entrypoint.LibWoverBiome;

public class BiomeTagModificationWorker {
    final Map<HolderSetNamedAccessor<Biome>, List<Holder<Biome>>> unfrozen = new HashMap<HolderSetNamedAccessor<Biome>, List<Holder<Biome>>>();

    boolean addBiomeToTag(TagKey<Biome> tag, BiomePredicate.Context context) {
        return this.addBiomeToTag(tag, context.biomes, context.biomeKey, context.biomeHolder);
    }

    public boolean addBiomeToTag(TagKey<Biome> tag, Registry<Biome> biomes, ResourceKey<Biome> biomeKey, Holder<Biome> biomeHolder) {
        HolderSet.Named tagHolder = biomes.getOrCreateTag(tag);
        if (tagHolder instanceof HolderSetNamedAccessor) {
            HolderSetNamedAccessor biomeTagHolder = (HolderSetNamedAccessor)tagHolder;
            if (biomeTagHolder.wover_getContents().stream().map(Holder::unwrapKey).filter(Optional::isPresent).map(Optional::get).anyMatch(key -> key.equals(biomeKey))) {
                return false;
            }
            List contents = this.unfrozen.computeIfAbsent(biomeTagHolder, holder -> new LinkedList(biomeTagHolder.wover_getContents()));
            contents.add(biomeHolder);
            return true;
        }
        LibWoverBiome.C.log.warn("Failed to alter BiomeTag {}", new Object[]{tag.location()});
        return false;
    }

    public boolean finished() {
        if (!this.unfrozen.isEmpty()) {
            this.unfrozen.forEach((tag, contents) -> tag.wover_setContents(List.copyOf(contents)));
            this.unfrozen.clear();
            return true;
        }
        return false;
    }
}

