/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.block.api;

import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import org.jetbrains.annotations.NotNull;

public class BlockProperties {
    public static final EnumProperty<TripleShape> TRIPLE_SHAPE = EnumProperty.create((String)"shape", TripleShape.class);
    public static final EnumProperty<PentaShape> PENTA_SHAPE = EnumProperty.create((String)"shape", PentaShape.class);
    public static final BooleanProperty TRANSITION = BooleanProperty.create((String)"transition");
    public static final BooleanProperty HAS_LIGHT = BooleanProperty.create((String)"has_light");
    public static final BooleanProperty IS_FLOOR = BooleanProperty.create((String)"is_floor");
    public static final BooleanProperty NATURAL = BooleanProperty.create((String)"natural");
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final BooleanProperty SMALL = BooleanProperty.create((String)"small");
    public static final IntegerProperty DEFAULT_ANVIL_DURABILITY = IntegerProperty.create((String)"durability", (int)0, (int)3);
    public static final IntegerProperty DESTRUCTION = IntegerProperty.create((String)"destruction", (int)0, (int)2);
    public static final IntegerProperty ROTATION = IntegerProperty.create((String)"rotation", (int)0, (int)3);
    public static final IntegerProperty FULLNESS = IntegerProperty.create((String)"fullness", (int)0, (int)3);
    public static final IntegerProperty COLOR = IntegerProperty.create((String)"color", (int)0, (int)7);
    public static final IntegerProperty SIZE = IntegerProperty.create((String)"size", (int)0, (int)7);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    public static final IntegerProperty AGE_THREE = BlockStateProperties.AGE_2;
    public static final BooleanProperty BOTTOM = BooleanProperty.create((String)"bottom");
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");

    public static enum TripleShape implements StringRepresentable
    {
        TOP("top", 0),
        MIDDLE("middle", 1),
        BOTTOM("bottom", 2);

        private final String name;
        private final int index;

        private TripleShape(String name, int index) {
            this.name = name;
            this.index = index;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public static TripleShape fromIndex(int index) {
            return index > 1 ? BOTTOM : (index == 1 ? MIDDLE : TOP);
        }
    }

    public static enum PentaShape implements StringRepresentable
    {
        BOTTOM("bottom"),
        PRE_BOTTOM("pre_bottom"),
        MIDDLE("middle"),
        PRE_TOP("pre_top"),
        TOP("top");

        private final String name;

        private PentaShape(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

