/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.block.api.model;

import com.google.gson.JsonElement;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;

public class WoverBlockModelGeneratorsAccess
extends BlockModelGenerators {
    public WoverBlockModelGeneratorsAccess(Consumer<BlockStateGenerator> blockStateOutput, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput, Consumer<Item> skippedAutoModelsOutput) {
        super(blockStateOutput, modelOutput, skippedAutoModelsOutput);
    }

    public Consumer<BlockStateGenerator> blockStateOutput() {
        return this.blockStateOutput;
    }

    public BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput() {
        return this.modelOutput;
    }

    public Map<Block, TexturedModel> texturedModels() {
        return this.texturedModels;
    }

    public void skipAutoItemBlock(Block block) {
        super.skipAutoItemBlock(block);
    }

    public void delegateItemModel(Block block, ResourceLocation model) {
        super.delegateItemModel(block, model);
    }

    public void createSimpleFlatItemModel(Item item) {
        super.createSimpleFlatItemModel(item);
    }

    public void createSimpleFlatItemModel(Block block) {
        Item item = block.asItem();
        if (item == Items.AIR) {
            return;
        }
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layer0((Block)block), this.modelOutput);
    }

    public void createDoor(Block block) {
        super.createDoor(block);
    }

    public void createOrientableTrapdoor(Block block) {
        super.createOrientableTrapdoor(block);
    }

    public void createTrapdoor(Block block) {
        super.createTrapdoor(block);
    }

    public void createCraftingTableLike(Block craftingTableBlock, Block craftingTableMaterialBlock, BiFunction<Block, Block, TextureMapping> textureMappingGetter) {
        TextureMapping textureMapping = textureMappingGetter.apply(craftingTableBlock, craftingTableMaterialBlock);
        this.blockStateOutput.accept(WoverBlockModelGeneratorsAccess.createSimpleBlock(craftingTableBlock, ModelTemplates.CUBE.create(craftingTableBlock, textureMapping, this.modelOutput)));
    }

    public void createNonTemplateHorizontalBlock(Block block) {
        this.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block))).with(WoverBlockModelGeneratorsAccess.createHorizontalFacingDispatch()));
    }

    public PropertyDispatch createColumnWithFacing() {
        return PropertyDispatch.property((Property)BlockStateProperties.FACING).select((Comparable)Direction.DOWN, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.UP, Variant.variant()).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90));
    }

    public static PropertyDispatch createHorizontalFacingDispatch() {
        return PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, Variant.variant());
    }

    public static MultiVariantGenerator createSimpleBlock(Block block, ResourceLocation modelLocation) {
        return BlockModelGenerators.createSimpleBlock((Block)block, (ResourceLocation)modelLocation);
    }

    public static BlockStateGenerator createButton(Block block, ResourceLocation button, ResourceLocation pressed) {
        return BlockModelGenerators.createButton((Block)block, (ResourceLocation)button, (ResourceLocation)pressed);
    }

    public static BlockStateGenerator createCustomFence(Block block, ResourceLocation post, ResourceLocation sideNorth, ResourceLocation sideEast, ResourceLocation sideSouth, ResourceLocation sideWest) {
        return BlockModelGenerators.createCustomFence((Block)block, (ResourceLocation)post, (ResourceLocation)sideNorth, (ResourceLocation)sideEast, (ResourceLocation)sideSouth, (ResourceLocation)sideWest);
    }

    public static BlockStateGenerator createFence(Block block, ResourceLocation post, ResourceLocation side) {
        return BlockModelGenerators.createFence((Block)block, (ResourceLocation)post, (ResourceLocation)side);
    }

    public static BlockStateGenerator createWall(Block block, ResourceLocation post, ResourceLocation sideLow, ResourceLocation sideTall) {
        return BlockModelGenerators.createWall((Block)block, (ResourceLocation)post, (ResourceLocation)sideLow, (ResourceLocation)sideTall);
    }

    public static BlockStateGenerator createFenceGate(Block block, ResourceLocation open, ResourceLocation closed, ResourceLocation wallOpen, ResourceLocation wallClosed, boolean uvlock) {
        return BlockModelGenerators.createFenceGate((Block)block, (ResourceLocation)open, (ResourceLocation)closed, (ResourceLocation)wallOpen, (ResourceLocation)wallClosed, (boolean)uvlock);
    }

    public static BlockStateGenerator createStairs(Block block, ResourceLocation inner, ResourceLocation straight, ResourceLocation outer) {
        PropertyDispatch.C4 dispatch = PropertyDispatch.properties((Property)BlockStateProperties.HORIZONTAL_FACING, (Property)BlockStateProperties.HALF, (Property)BlockStateProperties.STAIRS_SHAPE, (Property)BlockStateProperties.WATERLOGGED);
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.EAST, Half.BOTTOM, StairsShape.STRAIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(straight, VariantProperties.Rotation.R0, VariantProperties.Rotation.R0, false));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.WEST, Half.BOTTOM, StairsShape.STRAIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(straight, VariantProperties.Rotation.R0, VariantProperties.Rotation.R180, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.SOUTH, Half.BOTTOM, StairsShape.STRAIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(straight, VariantProperties.Rotation.R0, VariantProperties.Rotation.R90, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.NORTH, Half.BOTTOM, StairsShape.STRAIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(straight, VariantProperties.Rotation.R0, VariantProperties.Rotation.R270, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.EAST, Half.BOTTOM, StairsShape.INNER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R0, VariantProperties.Rotation.R270, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.WEST, Half.BOTTOM, StairsShape.INNER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R0, VariantProperties.Rotation.R90, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.SOUTH, Half.BOTTOM, StairsShape.INNER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R0, VariantProperties.Rotation.R0, false));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.NORTH, Half.BOTTOM, StairsShape.INNER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R0, VariantProperties.Rotation.R180, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.EAST, Half.BOTTOM, StairsShape.INNER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R0, VariantProperties.Rotation.R0, false));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.WEST, Half.BOTTOM, StairsShape.INNER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R0, VariantProperties.Rotation.R180, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.SOUTH, Half.BOTTOM, StairsShape.INNER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R0, VariantProperties.Rotation.R90, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.NORTH, Half.BOTTOM, StairsShape.INNER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R0, VariantProperties.Rotation.R270, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.EAST, Half.BOTTOM, StairsShape.OUTER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R0, VariantProperties.Rotation.R270, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.WEST, Half.BOTTOM, StairsShape.OUTER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R0, VariantProperties.Rotation.R90, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.SOUTH, Half.BOTTOM, StairsShape.OUTER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R0, VariantProperties.Rotation.R0, false));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.NORTH, Half.BOTTOM, StairsShape.OUTER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R0, VariantProperties.Rotation.R180, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.EAST, Half.BOTTOM, StairsShape.OUTER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R0, VariantProperties.Rotation.R0, false));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.WEST, Half.BOTTOM, StairsShape.OUTER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R0, VariantProperties.Rotation.R180, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.SOUTH, Half.BOTTOM, StairsShape.OUTER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R0, VariantProperties.Rotation.R90, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.NORTH, Half.BOTTOM, StairsShape.OUTER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R0, VariantProperties.Rotation.R270, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.EAST, Half.TOP, StairsShape.STRAIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(straight, VariantProperties.Rotation.R180, VariantProperties.Rotation.R0, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.WEST, Half.TOP, StairsShape.STRAIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(straight, VariantProperties.Rotation.R180, VariantProperties.Rotation.R180, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.SOUTH, Half.TOP, StairsShape.STRAIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(straight, VariantProperties.Rotation.R180, VariantProperties.Rotation.R90, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.NORTH, Half.TOP, StairsShape.STRAIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(straight, VariantProperties.Rotation.R180, VariantProperties.Rotation.R270, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.EAST, Half.TOP, StairsShape.INNER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R180, VariantProperties.Rotation.R0, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.WEST, Half.TOP, StairsShape.INNER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R180, VariantProperties.Rotation.R180, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.SOUTH, Half.TOP, StairsShape.INNER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R180, VariantProperties.Rotation.R90, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.NORTH, Half.TOP, StairsShape.INNER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R180, VariantProperties.Rotation.R270, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.EAST, Half.TOP, StairsShape.INNER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R180, VariantProperties.Rotation.R90, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.WEST, Half.TOP, StairsShape.INNER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R180, VariantProperties.Rotation.R270, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.SOUTH, Half.TOP, StairsShape.INNER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R180, VariantProperties.Rotation.R180, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.NORTH, Half.TOP, StairsShape.INNER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(inner, VariantProperties.Rotation.R180, VariantProperties.Rotation.R0, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.EAST, Half.TOP, StairsShape.OUTER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R180, VariantProperties.Rotation.R0, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.WEST, Half.TOP, StairsShape.OUTER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R180, VariantProperties.Rotation.R180, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.SOUTH, Half.TOP, StairsShape.OUTER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R180, VariantProperties.Rotation.R90, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.NORTH, Half.TOP, StairsShape.OUTER_LEFT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R180, VariantProperties.Rotation.R270, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.EAST, Half.TOP, StairsShape.OUTER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R180, VariantProperties.Rotation.R90, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.WEST, Half.TOP, StairsShape.OUTER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R180, VariantProperties.Rotation.R270, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.SOUTH, Half.TOP, StairsShape.OUTER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R180, VariantProperties.Rotation.R180, true));
        WoverBlockModelGeneratorsAccess.selectStairsVariant((PropertyDispatch.C4<Direction, Half, StairsShape, Boolean>)dispatch, Direction.NORTH, Half.TOP, StairsShape.OUTER_RIGHT, WoverBlockModelGeneratorsAccess.stairsVariant(outer, VariantProperties.Rotation.R180, VariantProperties.Rotation.R0, true));
        return MultiVariantGenerator.multiVariant((Block)block).with((PropertyDispatch)dispatch);
    }

    private static void selectStairsVariant(PropertyDispatch.C4<Direction, Half, StairsShape, Boolean> dispatch, Direction facing, Half half, StairsShape shape, Variant variant) {
        dispatch.select((Comparable)facing, (Comparable)half, (Comparable)shape, (Comparable)Boolean.valueOf(false), variant);
        dispatch.select((Comparable)facing, (Comparable)half, (Comparable)shape, (Comparable)Boolean.valueOf(true), variant);
    }

    private static Variant stairsVariant(ResourceLocation model, VariantProperties.Rotation xRot, VariantProperties.Rotation yRot, boolean uvLock) {
        Variant variant = Variant.variant().with(VariantProperties.MODEL, (Object)model);
        if (xRot != VariantProperties.Rotation.R0) {
            variant = variant.with(VariantProperties.X_ROT, (Object)xRot);
        }
        if (yRot != VariantProperties.Rotation.R0) {
            variant = variant.with(VariantProperties.Y_ROT, (Object)yRot);
        }
        if (uvLock) {
            variant = variant.with(VariantProperties.UV_LOCK, (Object)true);
        }
        return variant;
    }

    public static BlockStateGenerator createAxisAlignedPillarBlock(Block block, ResourceLocation modelLocation) {
        return BlockModelGenerators.createAxisAlignedPillarBlock((Block)block, (ResourceLocation)modelLocation);
    }

    public static BlockStateGenerator createPressurePlate(Block block, ResourceLocation up, ResourceLocation down) {
        return BlockModelGenerators.createPressurePlate((Block)block, (ResourceLocation)up, (ResourceLocation)down);
    }

    public static BlockStateGenerator createSlab(Block block, ResourceLocation bottom, ResourceLocation top, ResourceLocation fullBlock) {
        return BlockModelGenerators.createSlab((Block)block, (ResourceLocation)bottom, (ResourceLocation)top, (ResourceLocation)fullBlock);
    }
}

