/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api;

import java.util.List;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverDataProvider;
import org.betterx.wover.datagen.api.WoverMultiProvider;
import org.betterx.wover.datagen.api.WoverRegistryProvider;
import org.betterx.wover.datagen.impl.PackBuilderImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackBuilder
extends PackBuilderImpl {
    @NotNull
    public final ModCore modCore;
    @Nullable
    public final ResourceLocation location;
    PackOutput packOutput;
    DatapackBootstrap datapackBootstrap;

    PackBuilder(@NotNull ModCore modCore, @Nullable ResourceLocation location) {
        this.location = location;
        this.modCore = modCore;
    }

    public <T> PackBuilder addRegistryProvider(RegistryFactory<T> provider) {
        this.providerFactories.add(provider.create(this.modCore));
        return this;
    }

    public <T extends DataProvider> PackBuilder addProvider(ProviderFactory<T> provider) {
        super.addProviderWithRedirect(provider.create(this.modCore));
        return this;
    }

    public <T extends WoverMultiProvider> PackBuilder addMultiProvider(MultiProviderFactory<T> provider) {
        provider.create(this.modCore).registerAllProviders(this);
        return this;
    }

    public PackBuilder callOnInitializeDatapack(@Nullable DatapackBootstrap datapackBootstrap) {
        this.datapackBootstrap = datapackBootstrap;
        return this;
    }

    List<WoverDataProvider<?>> providerFactories() {
        return this.providerFactories;
    }

    public List<? extends WoverRegistryProvider<?>> registryProviders() {
        return this.providerFactories.stream().filter(provider -> provider instanceof WoverRegistryProvider).map(provider -> (WoverRegistryProvider)provider).toList();
    }

    PackBuilder pack(PackOutput packOutput) {
        this.packOutput = packOutput;
        return this;
    }

    @Override
    protected ModCore modCore() {
        return this.modCore;
    }

    @FunctionalInterface
    public static interface RegistryFactory<T>
    extends ProviderFactory<DataProvider> {
        @Override
        public WoverRegistryProvider<T> create(ModCore var1);
    }

    @FunctionalInterface
    public static interface ProviderFactory<T extends DataProvider> {
        public WoverDataProvider<T> create(ModCore var1);
    }

    @FunctionalInterface
    public static interface MultiProviderFactory<T extends WoverMultiProvider> {
        public T create(ModCore var1);
    }

    @FunctionalInterface
    public static interface DatapackBootstrap {
        public void bootstrap(GatherDataEvent var1, PackOutput var2, ResourceLocation var3);
    }
}

