/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.features.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.betterx.wover.block.api.BlockProperties;
import org.jetbrains.annotations.NotNull;

public class PillarFeatureConfig
implements FeatureConfiguration {
    public static final Codec<PillarFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.CODEC.fieldOf("min_height").forGetter(o -> o.minHeight), (App)IntProvider.CODEC.fieldOf("max_height").forGetter(o -> o.maxHeight), (App)Direction.CODEC.fieldOf("direction").orElse((Object)Direction.UP).forGetter(o -> o.direction), (App)BlockPredicate.CODEC.fieldOf("allowed_placement").forGetter(o -> o.allowedPlacement), (App)BlockStateProvider.CODEC.fieldOf("state").forGetter(o -> o.stateProvider), (App)KnownTransformers.CODEC.fieldOf("transform").forGetter(o -> o.transformer)).apply((Applicative)instance, PillarFeatureConfig::new));
    public final IntProvider maxHeight;
    public final IntProvider minHeight;
    public final BlockStateProvider stateProvider;
    public final KnownTransformers transformer;
    public final Direction direction;
    public final BlockPredicate allowedPlacement;

    public PillarFeatureConfig(IntProvider minHeight, IntProvider maxHeight, Direction direction, BlockPredicate allowedPlacement, BlockStateProvider stateProvider, KnownTransformers transformer) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.stateProvider = stateProvider;
        this.transformer = transformer;
        this.direction = direction;
        this.allowedPlacement = allowedPlacement;
    }

    public BlockState transform(int currentHeight, int maxHeight, BlockPos pos, RandomSource rnd) {
        BlockState state = this.stateProvider.getState(rnd, pos);
        return this.transformer.stateTransform.apply(currentHeight, maxHeight, state, pos, rnd);
    }

    public static enum KnownTransformers implements StringRepresentable
    {
        SIZE_DECREASE("size_decrease", (height, maxHeight, state, pos, rnd) -> (BlockState)state.setValue((Property)BlockProperties.SIZE, (Comparable)Integer.valueOf(Math.max(0, Math.min(7, maxHeight - height))))),
        SIZE_INCREASE("size_increase", (height, maxHeight, state, pos, rnd) -> (BlockState)state.setValue((Property)BlockProperties.SIZE, (Comparable)Integer.valueOf(Math.max(0, Math.min(7, height))))),
        BOTTOM_GROW("bottom_grow", (height, maxHeight, state, pos, rnd) -> (BlockState)state.setValue((Property)BlockProperties.BOTTOM, (Comparable)Boolean.valueOf(height == maxHeight))),
        BOTTOM("bottom", (height, maxHeight, state, pos, rnd) -> (BlockState)state.setValue((Property)BlockProperties.BOTTOM, (Comparable)Boolean.valueOf(height == 0))),
        TRIPLE_SHAPE_FILL("triple_shape_fill", (height, maxHeight, state, pos, rnd) -> {
            if (height == 0) {
                return (BlockState)state.setValue(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM));
            }
            if (height == maxHeight) {
                return (BlockState)state.setValue(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP));
            }
            return (BlockState)state.setValue(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE));
        }, (minHeight, maxHeight, startPos, aboveTop, level, allow, rnd) -> !allow.test((Object)level, (Object)aboveTop));

        public static final StringRepresentable.EnumCodec<KnownTransformers> CODEC;
        public final String name;
        public final StateTransform stateTransform;
        public final PlacePredicate canPlace;

        private KnownTransformers(String name, StateTransform stateTransform) {
            this(name, stateTransform, PlacePredicate.ALLWAYS);
        }

        private KnownTransformers(String name, StateTransform stateTransform, PlacePredicate canPlace) {
            this.name = name;
            this.stateTransform = stateTransform;
            this.canPlace = canPlace;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(KnownTransformers::values);
        }
    }

    @FunctionalInterface
    public static interface StateTransform {
        public BlockState apply(int var1, int var2, BlockState var3, BlockPos var4, RandomSource var5);
    }

    @FunctionalInterface
    public static interface PlacePredicate {
        public static final PlacePredicate ALLWAYS = (min, max, start, above, level, allow, rnd) -> true;

        public boolean at(int var1, int var2, BlockPos var3, BlockPos var4, WorldGenLevel var5, BlockPredicate var6, RandomSource var7);
    }
}

