/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.placed.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.betterx.wover.feature.impl.placed.modifiers.PlacementModifiersImpl;
import org.betterx.wover.surface.api.noise.NoiseParameterManager;
import org.jetbrains.annotations.NotNull;

public class NoiseFilter
extends PlacementFilter {
    public static final MapCodec<NoiseFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.NOISE).fieldOf("noise").forGetter(o -> o.noise), (App)Codec.DOUBLE.optionalFieldOf("min_noise_level", (Object)-1.7976931348623157E308).forGetter(o -> o.minNoiseLevel), (App)Codec.DOUBLE.optionalFieldOf("max_noise_level", (Object)Double.MAX_VALUE).forGetter(o -> o.maxNoiseLevel), (App)Codec.FLOAT.optionalFieldOf("scale_xz", (Object)Float.valueOf(1.0f)).forGetter(o -> Float.valueOf(o.scaleXZ)), (App)Codec.FLOAT.optionalFieldOf("scale_y", (Object)Float.valueOf(1.0f)).forGetter(o -> Float.valueOf(o.scaleY))).apply((Applicative)instance, NoiseFilter::new));
    private final ResourceKey<NormalNoise.NoiseParameters> noise;
    private final double minNoiseLevel;
    private final double maxNoiseLevel;
    private final float scaleXZ;
    private final float scaleY;

    public NoiseFilter(ResourceKey<NormalNoise.NoiseParameters> noise, double minNoiseLevel, double maxNoiseLevel, float scaleXZ, float scaleY) {
        this.noise = noise;
        this.minNoiseLevel = minNoiseLevel;
        this.maxNoiseLevel = maxNoiseLevel;
        this.scaleXZ = scaleXZ;
        this.scaleY = scaleY;
    }

    protected boolean shouldPlace(PlacementContext ctx, RandomSource random, BlockPos pos) {
        NormalNoise normalNoise = NoiseParameterManager.getOrCreateNoise(ctx.getLevel().registryAccess(), random, this.noise);
        double v = normalNoise.getValue((double)((float)pos.getX() * this.scaleXZ), (double)((float)pos.getY() * this.scaleY), (double)((float)pos.getZ() * this.scaleXZ));
        return v > this.minNoiseLevel && v < this.maxNoiseLevel;
    }

    @NotNull
    public PlacementModifierType<?> type() {
        return PlacementModifiersImpl.NOISE_FILTER;
    }
}

