/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.configured;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.wover.feature.api.Features;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.configurators.AsSequence;
import org.betterx.wover.feature.api.features.SequenceFeature;
import org.betterx.wover.feature.api.features.config.SequenceFeatureConfig;
import org.betterx.wover.feature.api.placed.PlacedFeatureKey;
import org.betterx.wover.feature.impl.configured.FeatureConfiguratorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsSequenceImpl
extends FeatureConfiguratorImpl<SequenceFeatureConfig, SequenceFeature>
implements AsSequence {
    private final List<Holder<PlacedFeature>> features = new LinkedList<Holder<PlacedFeature>>();

    AsSequenceImpl(@Nullable BootstrapContext<ConfiguredFeature<?, ?>> ctx, @Nullable ResourceKey<ConfiguredFeature<?, ?>> key) {
        super(ctx, key);
    }

    @Override
    public AsSequence add(PlacedFeatureKey featureKey) {
        this.features.add(featureKey.getHolder(this.bootstrapContext != null ? this.bootstrapContext : this.getTransitiveBootstrapContext()));
        return this;
    }

    @Override
    public AsSequence add(Holder<PlacedFeature> holder) {
        this.features.add(holder);
        return this;
    }

    @Override
    @NotNull
    public SequenceFeatureConfig createConfiguration() {
        if (this.features.isEmpty()) {
            this.throwStateError("Sequence must have at least one feature");
        }
        return SequenceFeatureConfig.createSequence(this.features);
    }

    @Override
    @NotNull
    protected SequenceFeature getFeature() {
        return (SequenceFeature)Features.SEQUENCE;
    }

    public static class Key
    extends ConfiguredFeatureKey<AsSequence> {
        public Key(ResourceLocation id) {
            super(id);
        }

        @Override
        public AsSequence bootstrap(@NotNull BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
            return new AsSequenceImpl(ctx, this.key);
        }
    }
}

