/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.configured;

import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.configurators.WithConfiguration;
import org.betterx.wover.feature.impl.configured.FeatureConfiguratorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WithConfigurationImpl<F extends Feature<FC>, FC extends FeatureConfiguration>
extends FeatureConfiguratorImpl<FC, F>
implements WithConfiguration<F, FC> {
    private FC configuration;
    private F feature;

    WithConfigurationImpl(@Nullable BootstrapContext<ConfiguredFeature<?, ?>> ctx, @Nullable ResourceKey<ConfiguredFeature<?, ?>> key) {
        super(ctx, key);
    }

    @Override
    public WithConfiguration<F, FC> feature(F feature) {
        this.feature = feature;
        return this;
    }

    @Override
    public WithConfiguration<F, FC> configuration(FC config) {
        this.configuration = config;
        return this;
    }

    @Override
    @NotNull
    public FC createConfiguration() {
        if (this.feature == null) {
            this.throwStateError("Feature must be set before creating configuration");
        }
        if (this.configuration == null) {
            if (NoneFeatureConfiguration.NONE != null) {
                return (FC)NoneFeatureConfiguration.NONE;
            }
            return (FC)NoneFeatureConfiguration.INSTANCE;
        }
        return this.configuration;
    }

    @Override
    @NotNull
    protected F getFeature() {
        return this.feature;
    }

    public static class Key<F extends Feature<FC>, FC extends FeatureConfiguration>
    extends ConfiguredFeatureKey<WithConfiguration<F, FC>> {
        private final F feature;

        public Key(ResourceLocation id, F feature) {
            super(id);
            this.feature = feature;
        }

        @Override
        public WithConfiguration<F, FC> bootstrap(@NotNull BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
            return new WithConfigurationImpl(ctx, this.key).feature(this.feature);
        }
    }
}

