/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.placed;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.wover.feature.api.placed.BasePlacedFeatureKey;
import org.betterx.wover.feature.api.placed.FeaturePlacementBuilder;
import org.betterx.wover.feature.impl.placed.FeaturePlacementBuilderImpl;
import org.betterx.wover.feature.impl.placed.PlacedFeatureManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseFeatureKeyImpl<K extends BasePlacedFeatureKey<K>>
implements BasePlacedFeatureKey<K> {
    public final ResourceKey<PlacedFeature> key;
    protected GenerationStep.Decoration decoration = GenerationStep.Decoration.VEGETAL_DECORATION;

    BaseFeatureKeyImpl(ResourceLocation featureId) {
        this.key = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)featureId);
    }

    @Override
    public GenerationStep.Decoration getDecoration() {
        return this.decoration;
    }

    @Override
    public K setDecoration(GenerationStep.Decoration decoration) {
        this.decoration = decoration;
        return (K)this;
    }

    @Override
    public ResourceKey<PlacedFeature> key() {
        return null;
    }

    @Override
    @Nullable
    public Holder<PlacedFeature> getHolder(@Nullable HolderGetter<PlacedFeature> getter) {
        return PlacedFeatureManagerImpl.getHolder(getter, this.key);
    }

    @Override
    @Nullable
    public Holder<PlacedFeature> getHolder(@Nullable RegistryAccess access) {
        if (access == null) {
            return null;
        }
        return this.getHolder((HolderGetter<PlacedFeature>)access.lookupOrThrow(Registries.PLACED_FEATURE));
    }

    @Override
    @Nullable
    public Holder<PlacedFeature> getHolder(@NotNull BootstrapContext<?> context) {
        return this.getHolder((HolderGetter<PlacedFeature>)context.lookup(Registries.PLACED_FEATURE));
    }

    protected FeaturePlacementBuilder place(@NotNull BootstrapContext<PlacedFeature> bootstrapContext, Holder<ConfiguredFeature<?, ?>> holder) {
        return new FeaturePlacementBuilderImpl(bootstrapContext, this.key, holder);
    }
}

