/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.api.biomesource;

import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.impl.modification.BiomeTagModificationWorker;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceWithNoiseRelatedSettings;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceWithSeed;
import org.betterx.wover.common.generator.api.biomesource.MergeableBiomeSource;
import org.betterx.wover.common.generator.api.biomesource.ReloadableBiomeSource;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.api.biomesource.WoverBiomePicker;
import org.betterx.wover.generator.impl.biomesource.WoverBiomeSourceImpl;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;

public abstract class WoverBiomeSource
extends BiomeSource
implements ReloadableBiomeSource,
BiomeSourceWithNoiseRelatedSettings,
BiomeSourceWithSeed,
MergeableBiomeSource<WoverBiomeSource> {
    private boolean didCreatePickers = false;
    Set<Holder<Biome>> dynamicPossibleBiomes = Set.of();
    protected long currentSeed;
    protected int maxHeight;

    public WoverBiomeSource(long seed) {
        this.currentSeed = seed;
    }

    @NotNull
    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        this.reloadBiomes();
        return this.dynamicPossibleBiomes.stream();
    }

    @Override
    public final void setSeed(long seed) {
        if (seed != this.currentSeed) {
            LibWoverWorldGenerator.C.log.debug(this.toShortString() + "\n    --> new seed = " + seed);
            this.currentSeed = seed;
            this.initMap(seed);
        }
    }

    public final void setMaxHeight(int maxHeight) {
        if (this.maxHeight != maxHeight) {
            LibWoverWorldGenerator.C.log.debug(this.toShortString() + "\n    --> new height = " + maxHeight);
            this.maxHeight = maxHeight;
            this.onHeightChange(maxHeight);
        }
    }

    protected boolean wasBound() {
        return this.didCreatePickers;
    }

    protected abstract List<TagKey<Biome>> acceptedTags();

    protected abstract ResourceKey<Biome> fallbackBiome();

    public abstract String toShortString();

    protected abstract void onInitMap(long var1);

    protected abstract void onHeightChange(int var1);

    protected TagKey<Biome> defaultBiomeTag() {
        return this.acceptedTags().get(0);
    }

    protected List<TagToPicker> createFreshPickerMap() {
        return this.acceptedTags().stream().map(tag -> new TagToPicker((TagKey<Biome>)tag, new WoverBiomePicker(this.fallbackBiome()))).toList();
    }

    @Override
    public void onLoadGeneratorSettings(NoiseGeneratorSettings generator) {
        this.setMaxHeight(generator.noiseSettings().height());
    }

    protected void onFinishBiomeRebuild(List<TagToPicker> pickerMap) {
        for (TagToPicker tagToPicker : pickerMap) {
            tagToPicker.picker.rebuild();
        }
    }

    @NotNull
    protected String getNamespaces() {
        return WoverBiomeSourceImpl.getNamespaces(this.possibleBiomes());
    }

    protected TagKey<Biome> tagForUnknownBiome(Holder<Biome> biomeHolder, ResourceKey<Biome> biomeKey) {
        for (TagKey<Biome> type : this.acceptedTags()) {
            if (!biomeHolder.is(type)) continue;
            return type;
        }
        return this.defaultBiomeTag();
    }

    protected boolean addToPicker(BiomeData biomeData, TagKey<Biome> type, WoverBiomePicker picker) {
        picker.addBiome(biomeData);
        return true;
    }

    protected final void rebuildBiomes(boolean force) {
        if (!force && this.didCreatePickers) {
            return;
        }
        LibWoverWorldGenerator.C.log.verbose("Updating Pickers for " + this.toShortString());
        List<TagToPicker> pickers = this.createFreshPickerMap();
        this.dynamicPossibleBiomes = WoverBiomeSourceImpl.populateBiomePickers(pickers, this::addToPicker);
        if (this.dynamicPossibleBiomes == null) {
            this.dynamicPossibleBiomes = Set.of();
        }
        this.didCreatePickers = true;
        this.onFinishBiomeRebuild(pickers);
    }

    protected void reloadBiomes(boolean force) {
        this.rebuildBiomes(force);
        this.initMap(this.currentSeed);
    }

    @Override
    public void reloadBiomes() {
        this.reloadBiomes(true);
    }

    protected final void initMap(long seed) {
        LibWoverWorldGenerator.C.log.debug(this.toShortString() + "\n    --> Map Update");
        this.onInitMap(seed);
    }

    @Override
    public WoverBiomeSource mergeWithBiomeSource(BiomeSource inputBiomeSource) {
        Stopwatch sw = Stopwatch.createStarted();
        RegistryAccess access = WorldState.registryAccess();
        if (access == null) {
            access = WorldState.allStageRegistryAccess();
            if (access != null) {
                LibWoverWorldGenerator.C.log.verbose("Registries were not finalized before merging biome sources!");
            } else {
                LibWoverWorldGenerator.C.log.error("Unable to merge Biome Sources");
                return this;
            }
        }
        Registry biomes = access.registryOrThrow(Registries.BIOME);
        BiomeTagModificationWorker biomeTagWorker = new BiomeTagModificationWorker();
        int biomesAdded = 0;
        try {
            for (Holder biomeHolder : inputBiomeSource.possibleBiomes()) {
                ResourceKey key;
                TagKey<Biome> tag;
                if (!biomeHolder.unwrapKey().isPresent() || (tag = this.tagForUnknownBiome((Holder<Biome>)biomeHolder, (ResourceKey<Biome>)(key = (ResourceKey)biomeHolder.unwrapKey().orElseThrow()))) == null || biomeHolder.is(tag)) continue;
                biomeTagWorker.addBiomeToTag(tag, (Registry<Biome>)biomes, (ResourceKey<Biome>)key, (Holder<Biome>)biomeHolder);
                ++biomesAdded;
            }
            biomeTagWorker.finished();
        }
        catch (RuntimeException e) {
            LibWoverWorldGenerator.C.log.error("Error while rebuilding BiomeSources!", e);
        }
        catch (Exception e) {
            LibWoverWorldGenerator.C.log.error("Error while rebuilding BiomeSources!", e);
        }
        this.reloadBiomes();
        if (biomesAdded > 0) {
            LibWoverWorldGenerator.C.log.info("Merged {} biomes to {} in {}", new Object[]{biomesAdded, this.toShortString(), sw});
        }
        return this;
    }

    public record TagToPicker(TagKey<Biome> tag, WoverBiomePicker picker) {
    }

    @FunctionalInterface
    public static interface PickerAdder {
        public boolean add(BiomeData var1, TagKey<Biome> var2, WoverBiomePicker var3);
    }

    @FunctionalInterface
    public static interface PickerMapFactory {
        public List<TagToPicker> create(Registry<BiomeData> var1);
    }
}

