/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.biomesource;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeDataRegistry;
import org.betterx.wover.biome.impl.data.BiomeDataRegistryImpl;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.api.biomesource.WoverBiomeSource;
import org.betterx.wover.generator.impl.biomesource.BiomeSourceManagerImpl;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.util.Pair;
import org.jetbrains.annotations.Nullable;

public class WoverBiomeSourceImpl {
    public static String getNamespaces(Collection<Holder<Biome>> biomes) {
        List<String> namespaces = biomes.stream().filter(h -> h.unwrapKey().isPresent()).map(h -> ((ResourceKey)h.unwrapKey().get()).location().getNamespace()).toList();
        return namespaces.stream().distinct().map(n -> n + "(" + namespaces.stream().filter(n::equals).count() + ")").collect(Collectors.joining(", "));
    }

    @Nullable
    public static Set<Holder<Biome>> populateBiomePickers(List<WoverBiomeSource.TagToPicker> pickers, WoverBiomeSource.PickerAdder pickerAdder) {
        RegistryAccess access = WorldState.registryAccess();
        if (access == null) {
            access = WorldState.allStageRegistryAccess();
            if (access != null) {
                LibWoverWorldGenerator.C.log.verbose("Registries were not finalized before populating BiomePickers!");
            } else {
                if (!ModCore.isDatagen()) {
                    LibWoverWorldGenerator.C.log.verbose("Unable to build Biome List yet");
                }
                return null;
            }
        }
        HashSet<Holder<Biome>> allBiomes = new HashSet<Holder<Biome>>();
        HashSet addedBiomes = new HashSet();
        Registry biomes = access.registryOrThrow(Registries.BIOME);
        Registry biomeData = access.registry(BiomeDataRegistry.BIOME_DATA_REGISTRY).orElse(null);
        for (WoverBiomeSource.TagToPicker mapper : pickers) {
            Optional optionalTag = biomes.getTag(mapper.tag());
            if (!optionalTag.isPresent()) continue;
            HolderSet.Named tag = (HolderSet.Named)optionalTag.get();
            Set<ResourceLocation> excluded = BiomeSourceManagerImpl.getExcludedBiomes((TagKey<Biome>)tag.key());
            tag.stream().filter(holder -> holder.unwrapKey().isPresent()).map(holder -> new Pair<Holder, ResourceKey>((Holder)holder, (ResourceKey)holder.unwrapKey().get())).filter(pair -> !addedBiomes.contains(pair.second)).filter(pair -> !excluded.contains(((ResourceKey)pair.second).location())).sorted(Comparator.comparing(pair -> ((ResourceKey)pair.second).location().toString())).forEach(pair -> {
                BiomeData data = BiomeDataRegistryImpl.getFromRegistryOrTemp((Registry<BiomeData>)biomeData, (ResourceKey<Biome>)((ResourceKey)pair.second));
                boolean isPossible = data != null && data.isPickable() ? pickerAdder.add(data, mapper.tag(), mapper.picker()) : true;
                if (isPossible) {
                    addedBiomes.add((ResourceKey)pair.second);
                    allBiomes.add((Holder)pair.first);
                }
            });
        }
        return allBiomes;
    }

    public record PopulateResult(Set<Holder<Biome>> possibleBiomes, List<WoverBiomeSource.TagToPicker> pickers) {
    }
}

