/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.chunkgenerator;

import com.google.common.base.Stopwatch;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.betterx.wover.biome.impl.modification.BiomeTagModificationWorker;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceConfig;
import org.betterx.wover.common.generator.api.biomesource.BiomeSourceWithConfig;
import org.betterx.wover.common.generator.api.biomesource.ReloadableBiomeSource;
import org.betterx.wover.common.generator.api.chunkgenerator.EnforceableChunkGenerator;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.impl.biomesource.end.TheEndBiomesHelper;
import org.betterx.wover.generator.impl.biomesource.nether.NetherBiomesHelper;
import org.betterx.wover.generator.impl.chunkgenerator.ConfiguredChunkGenerator;
import org.betterx.wover.generator.impl.chunkgenerator.DimensionsWrapper;
import org.betterx.wover.generator.impl.chunkgenerator.WorldGeneratorConfigImpl;
import org.betterx.wover.tag.api.predefined.CommonBiomeTags;

class BiomeRepairHelper {
    private Map<ResourceKey<LevelStem>, ChunkGenerator> vanillaDimensions = null;

    BiomeRepairHelper() {
    }

    public static TagKey<Biome> getBiomeTagForDimension(ResourceKey<LevelStem> key) {
        if (key.equals((Object)LevelStem.END)) {
            return CommonBiomeTags.IS_END_HIGHLAND;
        }
        if (key.equals((Object)LevelStem.NETHER)) {
            return BiomeTags.IS_NETHER;
        }
        if (key.equals((Object)LevelStem.OVERWORLD)) {
            return BiomeTags.IS_OVERWORLD;
        }
        return null;
    }

    public Registry<LevelStem> repairBiomeSourceInAllDimensions(RegistryAccess registryAccess, Registry<LevelStem> dimensionRegistry) {
        Map<ResourceKey<LevelStem>, ChunkGenerator> configuredDimensions = WorldGeneratorConfigImpl.loadWorldDimensions(registryAccess, WorldGeneratorConfigImpl.getPresetsNbt());
        Registry biomes = registryAccess.registryOrThrow(Registries.BIOME);
        this.registerAllBiomesFromRegistry((Registry<Biome>)biomes);
        Set originalSet = dimensionRegistry.entrySet();
        for (Map.Entry entry : originalSet) {
            BiomeSource biomeSource;
            boolean didRepair = false;
            ResourceKey key = (ResourceKey)entry.getKey();
            LevelStem loadedStem = (LevelStem)entry.getValue();
            ChunkGenerator referenceGenerator = configuredDimensions.get(key);
            if (referenceGenerator instanceof EnforceableChunkGenerator) {
                EnforceableChunkGenerator enforcer = (EnforceableChunkGenerator)referenceGenerator;
                ChunkGenerator loadedChunkGenerator = loadedStem.generator();
                this.registerAllBiomesFromVanillaDimension(registryAccess, (Registry<Biome>)biomes, (ResourceKey<LevelStem>)key);
                if (enforcer.togetherShouldRepair(loadedChunkGenerator)) {
                    dimensionRegistry = enforcer.enforceGeneratorInWorldGenSettings(registryAccess, (ResourceKey<LevelStem>)key, (ResourceKey<DimensionType>)((ResourceKey)loadedStem.type().unwrapKey().orElseThrow()), loadedChunkGenerator, dimensionRegistry);
                    didRepair = true;
                } else {
                    BiomeSource biomeSource2 = loadedChunkGenerator.getBiomeSource();
                    if (biomeSource2 instanceof BiomeSourceWithConfig) {
                        BiomeSourceWithConfig refSource;
                        BiomeSourceWithConfig lodedSource = (BiomeSourceWithConfig)biomeSource2;
                        BiomeSource biomeSource3 = referenceGenerator.getBiomeSource();
                        if (biomeSource3 instanceof BiomeSourceWithConfig && !(refSource = (BiomeSourceWithConfig)biomeSource3).getBiomeSourceConfig().sameConfig((BiomeSourceConfig<?>)lodedSource.getBiomeSourceConfig())) {
                            lodedSource.setBiomeSourceConfig(refSource.getBiomeSourceConfig());
                        }
                    }
                }
            }
            if (didRepair || !((biomeSource = loadedStem.generator().getBiomeSource()) instanceof ReloadableBiomeSource)) continue;
            ReloadableBiomeSource reload = (ReloadableBiomeSource)biomeSource;
            reload.reloadBiomes();
        }
        BiomeRepairHelper.copyWorldPresetReference(dimensionRegistry, configuredDimensions);
        return dimensionRegistry;
    }

    private static void copyWorldPresetReference(Registry<LevelStem> dimensionRegistry, Map<ResourceKey<LevelStem>, ChunkGenerator> configuredDimensions) {
        for (Map.Entry loadedDimension : dimensionRegistry.entrySet()) {
            ConfiguredChunkGenerator loadedCfg;
            ChunkGenerator referenceGenerator = configuredDimensions.get(loadedDimension.getKey());
            if (!(referenceGenerator instanceof ConfiguredChunkGenerator)) continue;
            ConfiguredChunkGenerator refCfg = (ConfiguredChunkGenerator)referenceGenerator;
            ChunkGenerator chunkGenerator = ((LevelStem)loadedDimension.getValue()).generator();
            if (!(chunkGenerator instanceof ConfiguredChunkGenerator) || (loadedCfg = (ConfiguredChunkGenerator)chunkGenerator).wover_getConfiguredWorldPreset() != null) continue;
            loadedCfg.wover_setConfiguredWorldPreset(refCfg.wover_getConfiguredWorldPreset());
        }
    }

    private void registerAllBiomesFromRegistry(Registry<Biome> biomes) {
        Stopwatch sw = Stopwatch.createStarted();
        int biomesAdded = 0;
        BiomeTagModificationWorker biomeTagWorker = new BiomeTagModificationWorker();
        for (Map.Entry e : biomes.entrySet()) {
            Holder.Reference holder;
            TagKey<Biome> tag = null;
            if (NetherBiomesHelper.canGenerateInNether((ResourceKey<Biome>)((ResourceKey)e.getKey()))) {
                tag = BiomeTags.IS_NETHER;
            } else if (TheEndBiomesHelper.canGenerateAsMainIslandBiome((ResourceKey<Biome>)((ResourceKey)e.getKey()))) {
                tag = CommonBiomeTags.IS_END_CENTER;
            } else if (TheEndBiomesHelper.canGenerateAsHighlandsBiome((ResourceKey<Biome>)((ResourceKey)e.getKey()))) {
                tag = CommonBiomeTags.IS_END_HIGHLAND;
            } else if (TheEndBiomesHelper.canGenerateAsEndBarrens((ResourceKey<Biome>)((ResourceKey)e.getKey()))) {
                tag = CommonBiomeTags.IS_END_BARRENS;
            } else if (TheEndBiomesHelper.canGenerateAsSmallIslandsBiome((ResourceKey<Biome>)((ResourceKey)e.getKey()))) {
                tag = CommonBiomeTags.IS_SMALL_END_ISLAND;
            } else if (TheEndBiomesHelper.canGenerateAsEndMidlands((ResourceKey<Biome>)((ResourceKey)e.getKey()))) {
                tag = CommonBiomeTags.IS_END_MIDLAND;
            }
            if (tag == null || (holder = biomes.getHolderOrThrow((ResourceKey)e.getKey())).is(tag)) continue;
            biomeTagWorker.addBiomeToTag(tag, biomes, (ResourceKey<Biome>)((ResourceKey)e.getKey()), (Holder<Biome>)holder);
            ++biomesAdded;
        }
        biomeTagWorker.finished();
        if (biomesAdded > 0) {
            LibWoverWorldGenerator.C.log.info("Added tags for {} registered biomes in {}", new Object[]{biomesAdded, sw});
        }
    }

    private void registerAllBiomesFromVanillaDimension(RegistryAccess access, Registry<Biome> biomes, ResourceKey<LevelStem> key) {
        Stopwatch sw = Stopwatch.createStarted();
        int biomesAdded = 0;
        BiomeTagModificationWorker biomeTagWorker = new BiomeTagModificationWorker();
        TagKey<Biome> tag = BiomeRepairHelper.getBiomeTagForDimension(key);
        if (tag != null) {
            ChunkGenerator vanillaDim;
            if (this.vanillaDimensions == null) {
                this.vanillaDimensions = DimensionsWrapper.getDimensionsMap(access, (ResourceKey<WorldPreset>)WorldPresets.NORMAL);
            }
            if ((vanillaDim = (ChunkGenerator)this.vanillaDimensions.getOrDefault(key, null)) != null && vanillaDim.getBiomeSource() != null) {
                for (Holder biomeHolder : vanillaDim.getBiomeSource().possibleBiomes()) {
                    if (!biomeHolder.unwrapKey().isPresent() || biomeHolder.is(tag)) continue;
                    biomeTagWorker.addBiomeToTag(tag, biomes, (ResourceKey<Biome>)((ResourceKey)biomeHolder.unwrapKey().orElseThrow()), (Holder<Biome>)biomeHolder);
                    ++biomesAdded;
                }
            }
            biomeTagWorker.finished();
            if (biomesAdded > 0) {
                LibWoverWorldGenerator.C.log.info("Added {} biomes to {} in {}", new Object[]{biomesAdded, tag.location(), sw});
            }
        }
    }
}

