/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.chunkgenerator;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.wover.biome.mixin.ChunkGeneratorAccessor;
import org.betterx.wover.config.api.Configs;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.events.api.WorldLifecycle;
import org.betterx.wover.generator.impl.chunkgenerator.ConfiguredChunkGenerator;
import org.betterx.wover.generator.impl.chunkgenerator.WorldGeneratorConfigImpl;
import org.betterx.wover.generator.impl.chunkgenerator.WoverChunkGenerator;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.state.api.WorldConfig;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkGeneratorManagerImpl {
    private static final ResourceLocation LEGACY_ID = LegacyHelper.BCLIB_CORE.convertNamespace(WoverChunkGenerator.ID);
    private static final List<String> GENERATOR_IDS = new ArrayList<String>(1);
    private static final Map<ResourceLocation, MapCodec<? extends ChunkGenerator>> PENDING_GENERATORS = new LinkedHashMap<ResourceLocation, MapCodec<? extends ChunkGenerator>>();

    @ApiStatus.Internal
    public static Map<String, Supplier<TypeTemplate>> addGeneratorDSL(Map<String, Supplier<TypeTemplate>> map) {
        if (map.containsKey("minecraft:flat") && !ModCore.isDatagen()) {
            HashMap<String, Supplier<TypeTemplate>> nMap = new HashMap<String, Supplier<TypeTemplate>>(map);
            GENERATOR_IDS.forEach(id -> nMap.put((String)id, DSL::remainder));
            return ImmutableMap.copyOf(nMap);
        }
        return map;
    }

    @ApiStatus.Internal
    public static void initialize() {
        ChunkGeneratorManagerImpl.register(WoverChunkGenerator.ID, WoverChunkGenerator.CODEC);
        if (LegacyHelper.isLegacyEnabled()) {
            ChunkGeneratorManagerImpl.register(LEGACY_ID, LegacyHelper.wrap(WoverChunkGenerator.CODEC));
        }
        WorldConfig.registerMod(LibWoverWorldGenerator.C);
        WorldLifecycle.CREATED_NEW_WORLD_FOLDER.subscribe(ChunkGeneratorManagerImpl::onWorldCreation, 20000);
    }

    private static void onWorldCreation(LevelStorageSource.LevelStorageAccess storage, RegistryAccess access, Holder<WorldPreset> currentPreset, WorldDimensions dimensions, boolean recreated) {
        WorldGeneratorConfigImpl.createWorldConfig(currentPreset, dimensions);
    }

    public static void onWorldReCreate(LevelStorageSource.LevelStorageAccess storage, WorldCreationContext context) {
        CompoundTag configuredPreset = WorldGeneratorConfigImpl.getPresetsNbtFromFolder(storage);
        Map<ResourceKey<LevelStem>, ChunkGenerator> dimensions = WorldGeneratorConfigImpl.loadWorldDimensions(WorldState.allStageRegistryAccess(), configuredPreset);
        for (Map.Entry dimEntry : context.selectedDimensions().dimensions().entrySet()) {
            ConfiguredChunkGenerator loadGen;
            ChunkGenerator chunkGenerator;
            ConfiguredChunkGenerator refGen;
            ChunkGenerator refDim = dimensions.get(dimEntry.getKey());
            if (!(refDim instanceof ConfiguredChunkGenerator) || (refGen = (ConfiguredChunkGenerator)refDim).wover_getConfiguredWorldPreset() == null || !((chunkGenerator = ((LevelStem)dimEntry.getValue()).generator()) instanceof ConfiguredChunkGenerator) || (loadGen = (ConfiguredChunkGenerator)chunkGenerator).wover_getConfiguredWorldPreset() != null) continue;
            loadGen.wover_setConfiguredWorldPreset(refGen.wover_getConfiguredWorldPreset());
        }
    }

    public static void register(ResourceLocation location, MapCodec<? extends ChunkGenerator> codec) {
        String idString = location.toString();
        if (GENERATOR_IDS.contains(idString)) {
            throw new IllegalStateException("Duplicate generator id: " + idString);
        }
        GENERATOR_IDS.add(idString);
        PENDING_GENERATORS.put(location, codec);
    }

    public static void onRegister(RegisterEvent event) {
        if (!event.getRegistryKey().equals(Registries.CHUNK_GENERATOR)) {
            return;
        }
        event.register(Registries.CHUNK_GENERATOR, (T helper) -> PENDING_GENERATORS.forEach((location, codec) -> {
            MapCodec casted = codec;
            helper.register(location, (Object)casted);
        }));
    }

    public static String enumerateFeatureNamespaces(@NotNull ChunkGenerator chunkGenerator) {
        ChunkGeneratorAccessor acc;
        Supplier<List<FeatureSorter.StepFeatureData>> supplier;
        if (chunkGenerator instanceof ChunkGeneratorAccessor && (supplier = (acc = (ChunkGeneratorAccessor)chunkGenerator).wover_getFeaturesPerStep()) != null) {
            HashMap<String, Integer> namespaces = new HashMap<String, Integer>();
            try {
                List<FeatureSorter.StepFeatureData> list = supplier.get();
                if (list != null) {
                    for (FeatureSorter.StepFeatureData features : list) {
                        if (features == null) continue;
                        for (PlacedFeature feature : features.features()) {
                            ResourceLocation location;
                            if (feature == null) continue;
                            String namespace = null;
                            if (WorldState.registryAccess() != null && (location = WorldState.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).getKey((Object)feature)) != null) {
                                namespace = location.getNamespace();
                            }
                            if (namespace == null && feature.feature() != null && feature.feature().unwrapKey().isPresent()) {
                                namespace = ((ResourceKey)feature.feature().unwrapKey().get()).location().getNamespace();
                            }
                            if (namespace == null) {
                                namespace = "none";
                            }
                            namespaces.put(namespace, namespaces.getOrDefault(namespace, 0) + 1);
                        }
                    }
                }
            }
            catch (Throwable e) {
                LibWoverWorldGenerator.C.log.warn("Failed to enumerate feature namespaces", new Object[]{e});
            }
            return namespaces.entrySet().stream().map(entry -> (String)entry.getKey() + "(" + String.valueOf(entry.getValue()) + ")").reduce((a, b) -> a + ", " + b).orElse("none");
        }
        return "unknown";
    }

    public static String printGeneratorInfo(@Nullable String className, @NotNull ChunkGenerator generator) {
        StringBuilder sb = new StringBuilder();
        sb.append(className == null ? generator.getClass().getSimpleName() : className).append(" (").append(Integer.toHexString(generator.hashCode())).append(")");
        if (generator instanceof ConfiguredChunkGenerator) {
            ConfiguredChunkGenerator cfg = (ConfiguredChunkGenerator)generator;
            ResourceKey<WorldPreset> preset = cfg.wover_getConfiguredWorldPreset();
            sb.append("\n    preset     = ").append((Object)(preset == null ? "none" : preset.location()));
        }
        if (generator instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator noise = (NoiseBasedChunkGenerator)generator;
            Optional key = noise.generatorSettings().unwrapKey();
            sb.append("\n    noise      = ").append((Object)(key.isEmpty() ? "custom" : ((ResourceKey)key.get()).location()));
        }
        if (generator instanceof ChunkGeneratorAccessor) {
            sb.append("\n    features   = ").append(ChunkGeneratorManagerImpl.enumerateFeatureNamespaces(generator));
        }
        return sb.toString();
    }

    public static void printDimensionInfo(WorldDimensions dimensionRegistry) {
        if (!((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue()) {
            return;
        }
        ChunkGeneratorManagerImpl.printDimensionInfo("World Dimensions", dimensionRegistry.dimensions().entrySet());
    }

    public static void printDimensionInfo(Registry<LevelStem> dimensionRegistry) {
        if (!((Boolean)Configs.MAIN.verboseLogging.get()).booleanValue()) {
            return;
        }
        ChunkGeneratorManagerImpl.printDimensionInfo("World Dimensions", dimensionRegistry.entrySet());
    }

    public static void printDimensionInfo(String title, WorldDimensions dimensionRegistry) {
        ChunkGeneratorManagerImpl.printDimensionInfo(title, dimensionRegistry.dimensions().entrySet());
    }

    public static void printDimensionInfo(String title, Set<Map.Entry<ResourceKey<LevelStem>, LevelStem>> levels) {
        StringBuilder output = new StringBuilder(title + ": ");
        for (Map.Entry<ResourceKey<LevelStem>, LevelStem> entry : levels) {
            output.append("\n - ").append(entry.getKey().location()).append(": ").append("\n     ").append(entry.getValue().generator().toString().replace("\n", "\n     ")).append("\n     ").append(entry.getValue().generator().getBiomeSource().toString().replace("\n", "\n     "));
        }
        LibWoverWorldGenerator.C.log.info(output.toString());
    }
}

