/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.mixin.biomesource;

import java.util.LinkedHashSet;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.betterx.wover.generator.impl.biomesource.end.TheEndBiomesHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TheEndBiomeSource.class})
public class TheEndBiomeSourceMixin {
    @Shadow
    @Final
    private Holder<Biome> end;
    @Shadow
    @Final
    private Holder<Biome> highlands;
    @Shadow
    @Final
    private Holder<Biome> midlands;
    @Shadow
    @Final
    private Holder<Biome> islands;
    @Shadow
    @Final
    private Holder<Biome> barrens;

    @Inject(method={"collectPossibleBiomes"}, at={@At(value="HEAD")}, cancellable=true)
    private void wover_collectPossibleBiomes(CallbackInfoReturnable<Stream<Holder<Biome>>> cir) {
        LinkedHashSet<Holder<Biome>> holders = new LinkedHashSet<Holder<Biome>>();
        holders.add(this.end);
        holders.add(this.highlands);
        holders.add(this.midlands);
        holders.add(this.islands);
        holders.add(this.barrens);
        TheEndBiomesHelper.addAllPossibleBiomes(holders);
        cir.setReturnValue(holders.stream());
    }

    @Inject(method={"getNoiseBiome"}, at={@At(value="HEAD")}, cancellable=true)
    private void wover_getNoiseBiome(int x, int y, int z, Climate.Sampler sampler, CallbackInfoReturnable<Holder<Biome>> cir) {
        int sectionZ;
        int blockX = QuartPos.toBlock((int)x);
        int blockY = QuartPos.toBlock((int)y);
        int blockZ = QuartPos.toBlock((int)z);
        int sectionX = SectionPos.blockToSectionCoord((int)blockX);
        if ((long)sectionX * (long)sectionX + (long)(sectionZ = SectionPos.blockToSectionCoord((int)blockZ)) * (long)sectionZ <= 4096L) {
            ResourceKey<Biome> key = TheEndBiomesHelper.pickMainIslandKey(sampler, blockX, blockY, blockZ);
            cir.setReturnValue(TheEndBiomesHelper.resolveHolder(key, this.end));
            return;
        }
        int noiseX = (sectionX * 2 + 1) * 8;
        int noiseZ = (sectionZ * 2 + 1) * 8;
        double erosion = sampler.erosion().compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(noiseX, blockY, noiseZ));
        ResourceKey<Biome> highlandsKey = TheEndBiomesHelper.pickHighlandsKey(sampler, noiseX, blockY, noiseZ);
        if (erosion > 0.25) {
            cir.setReturnValue(TheEndBiomesHelper.resolveHolder(highlandsKey, this.highlands));
            return;
        }
        if (erosion >= -0.0625) {
            ResourceKey<Biome> midlandsKey = TheEndBiomesHelper.pickMidlandsKey(highlandsKey, sampler, noiseX, blockY, noiseZ);
            cir.setReturnValue(TheEndBiomesHelper.resolveHolder(midlandsKey, this.midlands));
            return;
        }
        if (erosion < -0.21875) {
            ResourceKey<Biome> islandsKey = TheEndBiomesHelper.pickSmallIslandsKey(sampler, noiseX, blockY, noiseZ);
            cir.setReturnValue(TheEndBiomesHelper.resolveHolder(islandsKey, this.islands));
        } else {
            ResourceKey<Biome> barrensKey = TheEndBiomesHelper.pickBarrensKey(highlandsKey, sampler, noiseX, blockY, noiseZ);
            cir.setReturnValue(TheEndBiomesHelper.resolveHolder(barrensKey, this.barrens));
        }
    }
}

