/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.preset.api;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.betterx.wover.core.api.registry.DatapackRegistryBuilder;
import org.betterx.wover.entrypoint.LibWoverWorldPreset;
import org.betterx.wover.events.api.Event;
import org.betterx.wover.events.api.types.OnBootstrapRegistry;
import org.betterx.wover.preset.api.WorldPresetInfo;
import org.betterx.wover.preset.impl.WorldPresetInfoImpl;
import org.betterx.wover.preset.impl.WorldPresetInfoRegistryImpl;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;

public class WorldPresetInfoRegistry {
    public static final Event<OnBootstrapRegistry<WorldPresetInfo>> BOOTSTRAP_WORLD_PRESET_INFO_REGISTRY = WorldPresetInfoRegistryImpl.BOOTSTRAP_WORLD_PRESET_INFO_REGISTRY;
    public static final ResourceKey<Registry<WorldPresetInfo>> WORLD_PRESET_INFO_REGISTRY = DatapackRegistryBuilder.createRegistryKey(LibWoverWorldPreset.C.id("wover/world_preset_info"));

    private WorldPresetInfoRegistry() {
    }

    public static ResourceKey<WorldPresetInfo> createKey(ResourceLocation ruleID) {
        return WorldPresetInfoRegistryImpl.createKey(ruleID);
    }

    public static ResourceKey<WorldPresetInfo> createKey(ResourceKey<WorldPreset> ruleID) {
        return WorldPresetInfoRegistry.createKey(ruleID.location());
    }

    @NotNull
    public static WorldPresetInfo getFor(ResourceKey<WorldPreset> key) {
        if (key == null) {
            return WorldPresetInfoImpl.DEFAULT;
        }
        Registry infos = WorldState.allStageRegistryAccess().registry(WORLD_PRESET_INFO_REGISTRY).orElse(null);
        if (infos == null) {
            LibWoverWorldPreset.C.LOG.error("WorldPresetInfoRegistry: Registry not read");
            return WorldPresetInfoImpl.DEFAULT;
        }
        if (!infos.containsKey(key.location())) {
            return WorldPresetInfoImpl.DEFAULT;
        }
        return (WorldPresetInfo)infos.get(key.location());
    }

    @NotNull
    public static WorldPresetInfo getFor(Holder<WorldPreset> holder) {
        if (holder != null && holder.unwrapKey().isPresent()) {
            return WorldPresetInfoRegistry.getFor((ResourceKey<WorldPreset>)((ResourceKey)holder.unwrapKey().get()));
        }
        return WorldPresetInfoImpl.DEFAULT;
    }

    @NotNull
    public static WorldPresetInfo getFor(WorldPreset preset) {
        if (preset == null) {
            return WorldPresetInfoImpl.DEFAULT;
        }
        Registry presets = WorldState.allStageRegistryAccess().registryOrThrow(Registries.WORLD_PRESET);
        Optional key = presets.getResourceKey((Object)preset);
        if (key.isPresent()) {
            return WorldPresetInfoRegistry.getFor((ResourceKey<WorldPreset>)((ResourceKey)key.get()));
        }
        return WorldPresetInfoImpl.DEFAULT;
    }
}

