/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.api;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.betterx.wover.events.api.Event;
import org.betterx.wover.events.api.types.OnBootstrapRegistry;
import org.betterx.wover.structure.api.StructureKey;
import org.betterx.wover.structure.api.StructureTypeKey;
import org.betterx.wover.structure.api.structures.nbt.RandomNbtStructure;
import org.betterx.wover.structure.impl.JigsawKeyImpl;
import org.betterx.wover.structure.impl.RandomNbtKeyImpl;
import org.betterx.wover.structure.impl.SimpleStructureKeyImpl;
import org.betterx.wover.structure.impl.StructureManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureManager {
    public static final Event<OnBootstrapRegistry<Structure>> BOOTSTRAP_STRUCTURES = StructureManagerImpl.BOOTSTRAP_STRUCTURES;
    public static final StructureType<RandomNbtStructure> RANDOM_NBT_STRUCTURE_TYPE = StructureManagerImpl.RANDOM_NBT_STRUCTURE_TYPE;
    public static final StructurePieceType RANDOM_NBT_STRUCTURE_PIECE = StructureManagerImpl.RANDOM_NBT_STRUCTURE_PIECE;

    private StructureManager() {
    }

    public static <S extends Structure> StructureKey.Simple<S> structure(ResourceLocation location, @NotNull StructureTypeKey<S> type) {
        return new SimpleStructureKeyImpl<S>(location, type);
    }

    public static <S extends Structure> StructureKey.Simple<S> structure(ResourceLocation location, @NotNull StructureTypeKey.StructureFactory<S> structureFactory, @NotNull MapCodec<S> codec) {
        return new SimpleStructureKeyImpl<S>(location, StructureManager.registerType(location, structureFactory, codec));
    }

    public static <S extends Structure> StructureKey.Simple<S> structure(ResourceLocation location, @NotNull StructureTypeKey.StructureFactory<S> structureFactory) {
        return new SimpleStructureKeyImpl<S>(location, StructureManager.registerType(location, structureFactory, Structure.simpleCodec(structureFactory::create)));
    }

    public static <S extends Structure> StructureKey.Jigsaw jigsaw(ResourceLocation location) {
        return new JigsawKeyImpl(location);
    }

    public static <S extends Structure> StructureKey.RandomNbt randomNbt(ResourceLocation location) {
        return new RandomNbtKeyImpl(location);
    }

    @Nullable
    public static Holder<Structure> getHolder(@Nullable HolderGetter<Structure> getter, @NotNull ResourceKey<Structure> key) {
        return StructureManagerImpl.getHolder(getter, key);
    }

    @Nullable
    public static Holder<Structure> getHolder(@Nullable BootstrapContext<?> context, @NotNull ResourceKey<Structure> key) {
        return StructureManagerImpl.getHolder((HolderGetter<Structure>)context.lookup(Registries.STRUCTURE), key);
    }

    @NotNull
    public static <S extends Structure> StructureTypeKey<S> registerType(@NotNull ResourceLocation location, @NotNull StructureTypeKey.StructureFactory<S> structureFactory) {
        return StructureManagerImpl.registerType(location, structureFactory, Structure.simpleCodec(structureFactory::create));
    }

    @NotNull
    public static <S extends Structure> StructureTypeKey<S> registerType(@NotNull ResourceLocation location, @NotNull StructureTypeKey.StructureFactory<S> structureFactory, @NotNull MapCodec<S> codec) {
        return StructureManagerImpl.registerType(location, structureFactory, codec);
    }

    @NotNull
    public static StructurePieceType registerPiece(@NotNull ResourceLocation location, @NotNull StructurePieceType pieceType) {
        return StructureManagerImpl.registerPiece(location, pieceType);
    }
}

