/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.tag.mixin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagLoader;
import org.betterx.wover.entrypoint.LibWoverTag;
import org.betterx.wover.tag.impl.TagManagerImpl;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={TagLoader.class})
public class TagLoaderMixin {
    @Final
    @Shadow
    private String directory;
    private static final Set<String> WOVER_LOGGED_DIRS = Collections.newSetFromMap(new ConcurrentHashMap());

    @ModifyArg(method={"loadAndBuild"}, at=@At(value="INVOKE", target="Lnet/minecraft/tags/TagLoader;build(Ljava/util/Map;)Ljava/util/Map;"))
    public Map<ResourceLocation, List<TagLoader.EntryWithSource>> wover_modifyTags(Map<ResourceLocation, List<TagLoader.EntryWithSource>> tagsMap) {
        if (WOVER_LOGGED_DIRS.add(this.directory)) {
            LibWoverTag.C.LOG.info("TagLoader directory={}", new Object[]{this.directory});
            if ("tags/block".equals(this.directory) || "tags/blocks".equals(this.directory)) {
                ResourceLocation terrain = ResourceLocation.fromNamespaceAndPath((String)"wover", (String)"surfaces/nether/terrain");
                ResourceLocation netherrack = ResourceLocation.fromNamespaceAndPath((String)"wover", (String)"surfaces/nether/netherrack");
                List<TagLoader.EntryWithSource> terrainEntries = tagsMap.get(terrain);
                List<TagLoader.EntryWithSource> netherrackEntries = tagsMap.get(netherrack);
                LibWoverTag.C.LOG.info("TagLoader prebuild block tags: terrain={} entries={}, netherrack={} entries={}", new Object[]{terrainEntries == null ? "missing" : Integer.valueOf(terrainEntries.size()), terrainEntries, netherrackEntries == null ? "missing" : Integer.valueOf(netherrackEntries.size()), netherrackEntries});
            }
        }
        return TagManagerImpl.didLoadTagMap(this.directory, tagsMap);
    }
}

