/*
 * Decompiled with CFR 0.152.
 */
package net.norevy.optileaves.common;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.norevy.optileaves.common.OptiLeavesMod;
import net.norevy.optileaves.configuration.Configuration;
import net.norevy.optileaves.util.LeafCullCache;

@Mod.EventBusSubscriber(modid="optileaves", value={Dist.CLIENT})
public class OptiLeavesEvents {
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Configuration.INSTANCE.debug && tickCounter++ >= 100) {
            tickCounter = 0;
            long hits = LeafCullCache.hits;
            long misses = LeafCullCache.misses;
            long invalidations = LeafCullCache.invalidations;
            if (hits + misses + invalidations > 0L) {
                OptiLeavesMod.getLogger().info("[OptiLeaves Stats] Hits: {}, Misses: {}, Invalidations: {}", new Object[]{hits, misses, invalidations});
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            LeafCullCache.removeChunk(event.getChunk().getPos().toLong());
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            LeafCullCache.clearAll();
        }
    }

    @SubscribeEvent
    public static void onClientLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        LeafCullCache.clearAll();
    }
}

