/*
 * Decompiled with CFR 0.152.
 */
package net.norevy.optileaves.common;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.common.Mod;
import net.norevy.optileaves.configuration.Configuration;
import net.norevy.optileaves.util.Compat;
import net.norevy.optileaves.util.LeafCullCache;
import org.slf4j.Logger;

@Mod(value="optileaves")
public class OptiLeavesMod {
    public static final String MOD_ID = "optileaves";
    private static final Logger LOGGER = LogUtils.getLogger();

    public OptiLeavesMod() {
        LOGGER.info("[OptiLeaves] Initializing...");
        Configuration.INSTANCE.load();
        Compat.init();
    }

    public static boolean shouldCullSide(BlockGetter view, BlockPos pos, Direction facing) {
        if (!Configuration.INSTANCE.enabled) {
            return false;
        }
        int maxDepth = Compat.isFancyLeaves() ? Configuration.INSTANCE.depth : 1;
        LeafCullCache.setEffectiveDepth(maxDepth);
        return LeafCullCache.shouldCull(view, pos, facing);
    }

    public static boolean computeShouldCullSide(BlockGetter view, BlockPos pos, Direction facing, int maxDepth) {
        boolean canCull = true;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int i = 1; i <= maxDepth && canCull; ++i) {
            mutablePos.set((Vec3i)pos).move(facing, i);
            BlockState state = view.getBlockState((BlockPos)mutablePos);
            boolean isLeaf = state != null && state.getBlock() instanceof LeavesBlock;
            canCull = canCull && isLeaf;
        }
        if (!Configuration.INSTANCE.debug || canCull) {
            // empty if block
        }
        return canCull;
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

